/*
 * Decompiled with CFR 0.152.
 */
package org.nyt.radio;

import java.util.List;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.nyt.radio.ChatUtil;
import org.nyt.radio.DisplayEntityManager;
import org.nyt.radio.Radio;

public class Item {
    private final Radio plugin = Radio.plugin;

    public ItemStack getItem() {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        new DisplayEntityManager().getSkullByValue(this.plugin.getConfig().getString("radio.skull_skin", "ewogICJ0aW1lc3RhbXAiIDogMTc1OTMwNjQ4NjQ2MiwKICAicHJvZmlsZUlkIiA6ICI4MTFkNjM0NzUwY2Y0ZDI0OTJmZDcxYTViZjZhZjI3MSIsCiAgInByb2ZpbGVOYW1lIiA6ICJzcGlmZnRvcGlhbW1wMSIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS84Mjc1NjA2YTA3MmYzODRjZWIyMTNjMWVlMmIzMTAxNWQ1ZGY0ZjY4MDFmNjRlMGFjMGM5ZGJkOGM1NTEwMWZjIgogICAgfQogIH0KfQ=="), item);
        ItemMeta meta = item.getItemMeta();
        String displayName = this.plugin.getConfig().getString("radio.display-name", "Radio");
        meta.displayName(ChatUtil.parse(displayName).decoration(TextDecoration.ITALIC, false));
        meta.getPersistentDataContainer().set(NamespacedKey.fromString((String)"radio"), PersistentDataType.BOOLEAN, (Object)true);
        item.setItemMeta(meta);
        return item;
    }

    private void setIngredient(ShapedRecipe recipe, char key, String materialName) {
        if (materialName == null || materialName.equalsIgnoreCase("AIR")) {
            return;
        }
        recipe.setIngredient(key, Material.valueOf((String)materialName.trim().toUpperCase()));
    }

    public void registerCraft() {
        if (!this.plugin.getConfig().getBoolean("radio.craft.enabled", true)) {
            return;
        }
        ItemStack item = this.getItem();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "radio");
        ShapedRecipe recipe = new ShapedRecipe(key, item);
        try {
            List recipeLines = this.plugin.getConfig().getStringList("radio.craft.recipe");
            String[] row1 = ((String)recipeLines.get(0)).split(",");
            String[] row2 = ((String)recipeLines.get(1)).split(",");
            String[] row3 = ((String)recipeLines.get(2)).split(",");
            recipe.shape(new String[]{"012", "345", "678"});
            this.setIngredient(recipe, '0', row1[0]);
            this.setIngredient(recipe, '1', row1[1]);
            this.setIngredient(recipe, '2', row1[2]);
            this.setIngredient(recipe, '3', row2[0]);
            this.setIngredient(recipe, '4', row2[1]);
            this.setIngredient(recipe, '5', row2[2]);
            this.setIngredient(recipe, '6', row3[0]);
            this.setIngredient(recipe, '7', row3[1]);
            this.setIngredient(recipe, '8', row3[2]);
        }
        catch (Exception e) {
            Radio.LOGGER.warn("Error while loading recipe: " + e.getMessage() + ". Using default recipe!");
            recipe.shape(new String[]{"CHC", "IJI", "RNR"});
            recipe.setIngredient('C', Material.COPPER_INGOT);
            recipe.setIngredient('H', Material.CHISELED_COPPER);
            recipe.setIngredient('I', Material.IRON_INGOT);
            recipe.setIngredient('J', Material.JUKEBOX);
            recipe.setIngredient('N', Material.NETHERITE_INGOT);
            recipe.setIngredient('R', Material.REDSTONE);
        }
        this.plugin.getServer().addRecipe((Recipe)recipe);
    }

    public void reloadCraft() {
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "radio");
        this.plugin.getServer().removeRecipe(key);
        this.registerCraft();
    }
}

