/*
 * Decompiled with CFR 0.152.
 */
package org.nyt.radio;

import de.maxhenkel.voicechat.api.BukkitVoicechatService;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.nyt.radio.CommandHandler;
import org.nyt.radio.CommandTabCompleter;
import org.nyt.radio.DataManager;
import org.nyt.radio.EventListener;
import org.nyt.radio.Item;
import org.nyt.radio.SimpleVoiceAddon;

public final class Radio
extends JavaPlugin {
    public static final String PLUGIN_ID = "Radio";
    public static final Logger LOGGER = LogManager.getLogger((String)"Radio");
    public static Radio plugin;
    @Nullable
    public SimpleVoiceAddon simpleVoiceAddon;
    private DataManager dataManager;

    public void onEnable() {
        plugin = this;
        this.saveDefaultConfig();
        this.dataManager = new DataManager();
        this.getCommand("radio").setTabCompleter((TabCompleter)new CommandTabCompleter());
        this.getCommand("radio").setExecutor((CommandExecutor)new CommandHandler());
        BukkitVoicechatService service = (BukkitVoicechatService)this.getServer().getServicesManager().load(BukkitVoicechatService.class);
        if (service != null) {
            this.simpleVoiceAddon = new SimpleVoiceAddon(this.dataManager);
            service.registerPlugin((VoicechatPlugin)this.simpleVoiceAddon);
        } else {
            LOGGER.error("Error while loading addon! Bye :(");
        }
        new Item().registerCraft();
        this.getServer().getPluginManager().registerEvents((Listener)new EventListener(this.simpleVoiceAddon, this.dataManager), (Plugin)this);
        LOGGER.info("Loaded " + this.dataManager.getAllBlocks().size() + " radio blocks!");
    }

    public void onDisable() {
        if (this.simpleVoiceAddon != null) {
            this.getServer().getServicesManager().unregister((Object)this.simpleVoiceAddon);
        }
    }
}

