/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.replayvoicechat.playback;

import de.maxhenkel.replayvoicechat.ReplayVoicechatPlugin;
import de.maxhenkel.replayvoicechat.net.EntitySoundPacket;
import de.maxhenkel.replayvoicechat.net.LocationalSoundPacket;
import de.maxhenkel.replayvoicechat.net.StaticSoundPacket;
import de.maxhenkel.voicechat.api.audiochannel.ClientAudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.ClientEntityAudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.ClientLocationalAudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.ClientStaticAudioChannel;
import de.maxhenkel.voicechat.api.events.OpenALSoundEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.lwjgl.openal.AL11;
import xyz.breadloaf.replaymodinterface.ReplayInterface;

public class AudioPlaybackManager {
    public static final AudioPlaybackManager INSTANCE = new AudioPlaybackManager();
    private final Map<UUID, ClientAudioChannel> audioChannels = new HashMap<UUID, ClientAudioChannel>();

    @Nullable
    private <T extends ClientAudioChannel> T getAudioChannel(Class<T> channelClass, UUID uuid) {
        ClientAudioChannel clientAudioChannel = this.audioChannels.get(uuid);
        if (clientAudioChannel == null) {
            return null;
        }
        if (clientAudioChannel.getClass().isAssignableFrom(channelClass)) {
            return (T)clientAudioChannel;
        }
        return null;
    }

    public void onEntitySound(EntitySoundPacket packet) {
        if (ReplayInterface.INSTANCE.isPlayerHidden(packet.getId())) {
            return;
        }
        ClientEntityAudioChannel channel = this.getAudioChannel(ClientEntityAudioChannel.class, packet.getId());
        if (channel == null) {
            channel = ReplayVoicechatPlugin.CLIENT_API.createEntityAudioChannel(packet.getId());
            this.audioChannels.put(packet.getId(), (ClientAudioChannel)channel);
        }
        channel.play(packet.getRawAudio());
    }

    public void onLocationalSound(LocationalSoundPacket packet) {
        if (ReplayInterface.INSTANCE.isPlayerHidden(packet.getId())) {
            return;
        }
        ClientLocationalAudioChannel channel = this.getAudioChannel(ClientLocationalAudioChannel.class, packet.getId());
        if (channel == null) {
            channel = ReplayVoicechatPlugin.CLIENT_API.createLocationalAudioChannel(packet.getId(), packet.getLocation());
            this.audioChannels.put(packet.getId(), (ClientAudioChannel)channel);
        } else {
            channel.setLocation(packet.getLocation());
        }
        channel.play(packet.getRawAudio());
    }

    public void onStaticSound(StaticSoundPacket packet) {
        if (ReplayInterface.INSTANCE.isPlayerHidden(packet.getId())) {
            return;
        }
        ClientStaticAudioChannel channel = this.getAudioChannel(ClientStaticAudioChannel.class, packet.getId());
        if (channel == null) {
            channel = ReplayVoicechatPlugin.CLIENT_API.createStaticAudioChannel(packet.getId());
            this.audioChannels.put(packet.getId(), (ClientAudioChannel)channel);
        }
        channel.play(packet.getRawAudio());
    }

    public static void setPlaybackRate(OpenALSoundEvent event) {
        if (ReplayInterface.INSTANCE.isInReplayEditor) {
            AL11.alSourcef((int)event.getSource(), (int)4099, (float)((float)ReplayInterface.getCurrentSpeed()));
        }
    }
}

