/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.replayvoicechat.playback;

import de.maxhenkel.replayvoicechat.ReplayVoicechat;
import de.maxhenkel.replayvoicechat.net.AbstractSoundPacket;
import de.maxhenkel.replayvoicechat.net.EntitySoundPacket;
import de.maxhenkel.replayvoicechat.net.LocationalSoundPacket;
import de.maxhenkel.replayvoicechat.net.Packet;
import de.maxhenkel.replayvoicechat.net.StaticSoundPacket;
import de.maxhenkel.replayvoicechat.net.VersionCompatibilityException;
import de.maxhenkel.replayvoicechat.rendering.VoicechatVoiceRenderer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import xyz.breadloaf.replaymodinterface.ReplayInterface;

public class NetManager {
    public static void init() {
        NetManager.registerPacket(EntitySoundPacket.class);
        NetManager.registerPacket(LocationalSoundPacket.class);
        NetManager.registerPacket(StaticSoundPacket.class);
    }

    public static <T extends Packet<?>> void registerPacket(final Class<T> packetClass) {
        try {
            Packet dummyPacket = (Packet)packetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            class_9139 codec = new class_9139<class_9129, T>(){

                public void encode(class_9129 buf, T packet) {
                    packet.toBytes((class_2540)buf);
                }

                public T decode(class_9129 buf) {
                    try {
                        Packet packet = (Packet)packetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        packet.fromBytes((class_2540)buf);
                        return packet;
                    }
                    catch (VersionCompatibilityException e) {
                        ReplayVoicechat.LOGGER.warn("Failed to read packet: {}", (Object)e.getMessage());
                        return null;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            class_8710.class_9154 type = dummyPacket.method_56479();
            PayloadTypeRegistry.playS2C().register(type, codec);
            ClientPlayNetworking.registerGlobalReceiver(type, (payload, context) -> {
                if (payload == null) {
                    return;
                }
                try {
                    if (ReplayInterface.INSTANCE.isRendering) {
                        if (class_310.method_1551().method_1560() != null) {
                            VoicechatVoiceRenderer.onRecordingPacket((AbstractSoundPacket)payload);
                        }
                        return;
                    }
                    if (ReplayInterface.INSTANCE.skipping) {
                        return;
                    }
                    context.client().execute(payload::onPacket);
                }
                catch (Exception e) {
                    ReplayVoicechat.LOGGER.error("Failed to process packet", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            ReplayVoicechat.LOGGER.error("Failed to register packet", (Throwable)e);
        }
    }
}

