/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.replayvoicechat.rendering;

import com.replaymod.render.rendering.VideoRenderer;
import de.maxhenkel.replayvoicechat.ReplayVoicechat;
import de.maxhenkel.replayvoicechat.net.AbstractSoundPacket;
import de.maxhenkel.replayvoicechat.net.EntitySoundPacket;
import de.maxhenkel.replayvoicechat.net.LocationalSoundPacket;
import de.maxhenkel.replayvoicechat.net.StaticSoundPacket;
import de.maxhenkel.replayvoicechat.sonic.Sonic;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.voice.client.AudioRecorder;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.InitializationData;
import de.maxhenkel.voicechat.voice.client.PositionalAudioUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import xyz.breadloaf.replaymodinterface.ReplayInterface;

public class VoicechatVoiceRenderer
extends Thread {
    public static final int SAMPLE_RATE = 48000;
    private static VoicechatVoiceRenderer INSTANCE;
    private static InitializationData data;
    private static final class_310 MC;
    private boolean running = true;
    private final LinkedBlockingQueue<PacketWrapper> packets = new LinkedBlockingQueue();
    private AudioRecorder recorder;
    private final HashMap<UUID, Sonic> sonicMap = new HashMap();

    public static void onStartRendering() {
        if (INSTANCE == null) {
            INSTANCE = new VoicechatVoiceRenderer();
            INSTANCE.startRecording();
        } else {
            ReplayVoicechat.LOGGER.warn("Started rendering when already rendering");
        }
    }

    public static void onStopRendering() {
        if (INSTANCE != null) {
            try {
                INSTANCE.stopAndWait();
            }
            catch (InterruptedException e) {
                ReplayVoicechat.LOGGER.error("Failed to stop rendering", (Throwable)e);
            }
        } else {
            throw new IllegalStateException("Stop called while stopped");
        }
        INSTANCE = null;
    }

    public static void onRecordingPacket(AbstractSoundPacket<?> packet) {
        if (INSTANCE != null && VoicechatVoiceRenderer.INSTANCE.running) {
            try {
                EntitySoundPacket p;
                class_243 cameraLocation = class_310.method_1551().field_1773.method_19418().method_19326();
                float yrot = class_310.method_1551().field_1773.method_19418().method_19330();
                ClientVoicechat client = ClientManager.getClient();
                if (client == null) {
                    return;
                }
                client.getTalkCache().updateLevel(packet.getId(), null, packet instanceof EntitySoundPacket && (p = (EntitySoundPacket)packet).isWhispering(), packet.getRawAudio());
                if (ReplayInterface.INSTANCE.isPlayerHidden(packet.getId())) {
                    return;
                }
                if (ReplayInterface.INSTANCE.videoRenderer != null) {
                    VoicechatVoiceRenderer.INSTANCE.packets.put(new PacketWrapper(packet, ReplayInterface.INSTANCE.videoRenderer.getVideoTime(), yrot, cameraLocation, ReplayInterface.getCurrentSpeed()));
                }
            }
            catch (InterruptedException e) {
                ReplayVoicechat.LOGGER.error("Failed to handle sound packet", (Throwable)e);
            }
        }
    }

    public static void onInitializationData(InitializationData data) {
        VoicechatVoiceRenderer.data = data;
    }

    private VoicechatVoiceRenderer() {
        this.setName("ReplayVoiceChatVoiceRenderThread");
        this.setUncaughtExceptionHandler((thread, throwable) -> ReplayVoicechat.LOGGER.error("Error in voice render thread", throwable));
    }

    private void startRecording() {
        String videoFileName = ReplayInterface.INSTANCE.videoRenderer.getRenderSettings().getOutputFile().getName();
        String filename = videoFileName.substring(0, videoFileName.lastIndexOf(46));
        Path path = ReplayInterface.INSTANCE.videoRenderer.getRenderSettings().getOutputFile().toPath().getParent().resolve(filename + "_audio");
        this.recorder = new AudioRecorder(path, 0L);
        ClientVoicechat client = ClientManager.getClient();
        if (client != null) {
            client.getTalkCache().setTimestampSupplier(() -> {
                VideoRenderer videoRenderer = ReplayInterface.INSTANCE.videoRenderer;
                if (videoRenderer != null) {
                    return videoRenderer.getVideoTime();
                }
                return System.currentTimeMillis();
            });
        }
        this.start();
    }

    @Override
    public void run() {
        while (this.running || this.packets.size() > 0) {
            PacketWrapper packetWrapper = null;
            try {
                packetWrapper = this.packets.poll(250L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                ReplayVoicechat.LOGGER.error("Failed to poll voice chat packets", (Throwable)e);
            }
            if (packetWrapper == null) continue;
            try {
                AbstractSoundPacket<?> abstractSoundPacket = packetWrapper.packet;
                if (abstractSoundPacket instanceof LocationalSoundPacket) {
                    LocationalSoundPacket packet = (LocationalSoundPacket)abstractSoundPacket;
                    this.onLocationalSoundPacket(packetWrapper, packet);
                    continue;
                }
                abstractSoundPacket = packetWrapper.packet;
                if (abstractSoundPacket instanceof EntitySoundPacket) {
                    EntitySoundPacket packet = (EntitySoundPacket)abstractSoundPacket;
                    this.onEntitySoundPacket(packetWrapper, packet);
                    continue;
                }
                abstractSoundPacket = packetWrapper.packet;
                if (!(abstractSoundPacket instanceof StaticSoundPacket)) continue;
                StaticSoundPacket packet = (StaticSoundPacket)abstractSoundPacket;
                this.onStaticSoundPacket(packetWrapper, packet);
            }
            catch (Exception e) {
                ReplayVoicechat.LOGGER.error("Failed to process packet", (Throwable)e);
            }
        }
        this.onStop();
    }

    private void onLocationalSoundPacket(PacketWrapper packetWrapper, LocationalSoundPacket locationalSoundPacket) {
        try {
            Position location = locationalSoundPacket.getLocation();
            this.recorder.appendChunk(locationalSoundPacket.getId(), (long)packetWrapper.timestamp, PositionalAudioUtils.convertToStereoForRecording((float)locationalSoundPacket.getDistance(), (class_243)packetWrapper.cameraPos, (float)packetWrapper.yrot, (class_243)new class_243(location.getX(), location.getY(), location.getZ()), (short[])this.setSpeed(locationalSoundPacket.getId(), locationalSoundPacket.getRawAudio(), packetWrapper.speed)));
        }
        catch (IOException e) {
            ReplayVoicechat.LOGGER.error("Failed to render locational sound", (Throwable)e);
        }
    }

    private void onEntitySoundPacket(PacketWrapper packetWrapper, EntitySoundPacket entitySoundPacket) {
        try {
            if (VoicechatVoiceRenderer.MC.field_1687 == null) {
                return;
            }
            class_1657 player = VoicechatVoiceRenderer.MC.field_1687.method_18470(entitySoundPacket.getId());
            if (player == null) {
                return;
            }
            class_243 pos = player.method_33571();
            this.recorder.appendChunk(entitySoundPacket.getId(), (long)packetWrapper.timestamp, PositionalAudioUtils.convertToStereoForRecording((float)entitySoundPacket.getDistance(), (class_243)packetWrapper.cameraPos, (float)packetWrapper.yrot, (class_243)pos, (short[])this.setSpeed(entitySoundPacket.getId(), entitySoundPacket.getRawAudio(), packetWrapper.speed)));
        }
        catch (IOException e) {
            ReplayVoicechat.LOGGER.error("Failed to render entity sound", (Throwable)e);
        }
    }

    private void onStaticSoundPacket(PacketWrapper packetWrapper, StaticSoundPacket staticSoundPacket) {
        try {
            this.recorder.appendChunk(staticSoundPacket.getId(), (long)packetWrapper.timestamp, PositionalAudioUtils.convertToStereo((short[])this.setSpeed(staticSoundPacket.getId(), staticSoundPacket.getRawAudio(), packetWrapper.speed)));
        }
        catch (IOException e) {
            ReplayVoicechat.LOGGER.error("Failed to render static sound", (Throwable)e);
        }
    }

    public short[] setSpeed(UUID channelId, short[] audio, double speed) {
        Sonic stream;
        if (speed >= 0.99 && speed <= 1.01) {
            return audio;
        }
        if (!this.sonicMap.containsKey(channelId)) {
            stream = new Sonic(48000, 1);
            this.sonicMap.put(channelId, stream);
        } else {
            stream = this.sonicMap.get(channelId);
        }
        stream.setSpeed((float)speed);
        stream.setPitch((float)speed);
        stream.writeShortToStream(audio, audio.length);
        stream.flushStream();
        int numSamples = stream.samplesAvailable();
        short[] outSamples = new short[numSamples];
        stream.readShortFromStream(outSamples, numSamples);
        return outSamples;
    }

    private void stopAndWait() throws InterruptedException {
        ReplayVoicechat.LOGGER.info("Stopping");
        this.running = false;
        this.join();
    }

    private void onStop() {
        this.recorder.saveAndClose();
        ReplayVoicechat.LOGGER.info("Voice chat data saved!");
        this.recorder.close();
    }

    static {
        MC = class_310.method_1551();
    }

    public static class PacketWrapper {
        public AbstractSoundPacket<?> packet;
        public int timestamp;
        public float yrot;
        public class_243 cameraPos;
        public double speed;

        public PacketWrapper(AbstractSoundPacket<?> packet, int timestamp, float yrot, class_243 cameraPos, double speed) {
            this.packet = packet;
            this.timestamp = timestamp;
            this.cameraPos = cameraPos;
            this.yrot = yrot;
            this.speed = speed;
        }
    }
}

