/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod;

import java.util.HashMap;
import net.minecraft.ChatFormatting;
import org.jetbrains.annotations.Nullable;

public class ColorUtils {
    public static final HashMap<String, Integer> colorNameToInt = new HashMap<String, Integer>(){
        {
            this.put("black", ChatFormatting.BLACK.m_126665_());
            this.put("darkblue", ChatFormatting.DARK_BLUE.m_126665_());
            this.put("darkgreen", ChatFormatting.DARK_GREEN.m_126665_());
            this.put("darkaqua", ChatFormatting.DARK_AQUA.m_126665_());
            this.put("darkred", ChatFormatting.DARK_RED.m_126665_());
            this.put("darkpurple", ChatFormatting.DARK_PURPLE.m_126665_());
            this.put("gold", ChatFormatting.GOLD.m_126665_());
            this.put("grey", ChatFormatting.GRAY.m_126665_());
            this.put("darkgrey", ChatFormatting.DARK_GRAY.m_126665_());
            this.put("blue", ChatFormatting.BLUE.m_126665_());
            this.put("green", ChatFormatting.GREEN.m_126665_());
            this.put("aqua", ChatFormatting.AQUA.m_126665_());
            this.put("red", ChatFormatting.RED.m_126665_());
            this.put("lightpurple", ChatFormatting.LIGHT_PURPLE.m_126665_());
            this.put("yellow", ChatFormatting.YELLOW.m_126665_());
            this.put("white", ChatFormatting.WHITE.m_126665_());
        }
    };

    @Nullable
    public static Integer parseColor(String colorNameOrHex) {
        String colorNameOrHexLower = colorNameOrHex.toLowerCase();
        if (colorNameToInt.containsKey(colorNameOrHexLower)) {
            return colorNameToInt.get(colorNameOrHex);
        }
        try {
            return Integer.parseInt(colorNameOrHexLower.substring(1), 16);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public static String getHexColor(@Nullable java.awt.Color color) {
        if (color == null) {
            return "#ffffff";
        }
        return "#" + Integer.toHexString(color.getRGB()).substring(2);
    }

    public static String getHexColor(int color) {
        return ColorUtils.getHexColor(new java.awt.Color(color));
    }

    public static class Color {
        public static final int CHANNEL_MENTION_COLOR = 6911177;
        public static int CHAT_LINK_COLOR = 47103;
    }
}

