/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod;

import com.denisnumb.discord_chat_mod.LocaleProvider;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.damagesource.FallLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class DeathMessageUtils {
    private static final Style INTENTIONAL_GAME_DESIGN_STYLE = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://bugs.mojang.com/browse/MCPE-28723")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"MCPE-28723")));
    public static final String DEATH_CAUSE_REPLACEMENT_TAG = "{death.cause}";
    public static final String DIED_ENTITY_REPLACEMENT_TAG = "{died.entity}";
    public static final String KILLER_ENTITY_REPLACEMENT_TAG = "{second.entity}";
    public static final String ITEM_REPLACEMENT_TAG = "{item}";

    public static DeathMessageComponents getDeathMessageComponents(List<CombatEntry> entries, LivingEntity diedEntity) {
        if (entries.isEmpty()) {
            return new DeathMessageComponents(DeathMessageUtils.getLocalizedDisplayName((Entity)diedEntity), (Component)Component.m_237113_((String)LocaleProvider.getTranslate("death.attack.generic")), null, null);
        }
        DamageSource damageSource = entries.get(entries.size() - 1).f_19250_();
        CombatEntry mostSignificantFall = DeathMessageUtils.getMostSignificantFall(entries);
        DeathMessageType deathMessageType = damageSource.m_269415_().f_268472_();
        if (deathMessageType == DeathMessageType.FALL_VARIANTS && mostSignificantFall != null) {
            return DeathMessageUtils.getFallMessage(mostSignificantFall, damageSource.m_7639_(), diedEntity);
        }
        if (deathMessageType == DeathMessageType.INTENTIONAL_GAME_DESIGN) {
            String base = "death.attack." + damageSource.m_19385_();
            MutableComponent intentionalGameDesign = ComponentUtils.m_130748_((Component)Component.m_237113_((String)LocaleProvider.getTranslate(base + ".link"))).m_130948_(INTENTIONAL_GAME_DESIGN_STYLE);
            return new DeathMessageComponents(DeathMessageUtils.getLocalizedDisplayName((Entity)diedEntity), (Component)Component.m_237113_((String)LocaleProvider.getTranslate(base + "message")), (Component)intentionalGameDesign, null);
        }
        return DeathMessageUtils.getLocalizedDeathMessage(damageSource, diedEntity);
    }

    private static DeathMessageComponents getFallMessage(CombatEntry combatEntry, @Nullable Entity killerEntity, LivingEntity diedEntity) {
        DamageSource damageSource = combatEntry.f_19250_();
        if (!damageSource.m_269533_(DamageTypeTags.f_268549_) && !damageSource.m_269533_(DamageTypeTags.f_268518_)) {
            Component killerEntityDisplayName = DeathMessageUtils.getLocalizedDisplayName(killerEntity);
            Entity fallCauseEntity = damageSource.m_7639_();
            Component fallCauseEntityDisplayName = DeathMessageUtils.getLocalizedDisplayName(fallCauseEntity);
            if (fallCauseEntityDisplayName != null && !fallCauseEntityDisplayName.equals((Object)killerEntityDisplayName)) {
                return DeathMessageUtils.getMessageForAssistedFall(fallCauseEntity, fallCauseEntityDisplayName, "death.fell.assist.item", "death.fell.assist", diedEntity);
            }
            return killerEntityDisplayName != null ? DeathMessageUtils.getMessageForAssistedFall(killerEntity, killerEntityDisplayName, "death.fell.finish.item", "death.fell.finish", diedEntity) : new DeathMessageComponents(DeathMessageUtils.getLocalizedDisplayName((Entity)diedEntity), (Component)Component.m_237113_((String)LocaleProvider.getTranslate("death.fell.killer")), null, null);
        }
        FallLocation fallLocation = Objects.requireNonNullElse(combatEntry.f_289042_(), FallLocation.f_289040_);
        return new DeathMessageComponents(DeathMessageUtils.getLocalizedDisplayName((Entity)diedEntity), (Component)Component.m_237113_((String)LocaleProvider.getTranslate(fallLocation.m_289192_())), null, null);
    }

    private static DeathMessageComponents getLocalizedDeathMessage(DamageSource source2, LivingEntity diedEntity) {
        Component diedEntityName = DeathMessageUtils.getLocalizedDisplayName((Entity)diedEntity);
        String attackBase = "death.attack." + source2.m_269415_().f_268677_();
        if (source2.m_7639_() == null && source2.m_7640_() == null) {
            LivingEntity playerKiller = diedEntity.m_21232_();
            String byPlayer = attackBase + ".player";
            return playerKiller != null ? new DeathMessageComponents(diedEntityName, (Component)Component.m_237113_((String)LocaleProvider.getTranslate(byPlayer)), DeathMessageUtils.getLocalizedDisplayName((Entity)playerKiller), null) : new DeathMessageComponents(diedEntityName, (Component)Component.m_237113_((String)LocaleProvider.getTranslate(attackBase)), null, null);
        }
        Component killerEntityName = source2.m_7639_() == null ? DeathMessageUtils.getLocalizedDisplayName(source2.m_7640_()) : DeathMessageUtils.getLocalizedDisplayName(source2.m_7639_());
        Entity entity = source2.m_7639_();
        ItemStack item = entity instanceof LivingEntity ? ((LivingEntity)entity).m_21205_() : ItemStack.f_41583_;
        return !item.m_41619_() && item.m_41788_() ? new DeathMessageComponents(diedEntityName, (Component)Component.m_237113_((String)LocaleProvider.getTranslate(attackBase + ".item")), killerEntityName, item.m_41611_()) : new DeathMessageComponents(diedEntityName, (Component)Component.m_237113_((String)LocaleProvider.getTranslate(attackBase)), killerEntityName, null);
    }

    private static DeathMessageComponents getMessageForAssistedFall(Entity killer, Component killerDisplayName, String withItem, String withoutItem, LivingEntity diedEntity) {
        ItemStack itemStack;
        if (killer instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)killer;
            itemStack = livingEntity.m_21205_();
        } else {
            itemStack = ItemStack.f_41583_;
        }
        ItemStack itemStack2 = itemStack;
        return !itemStack2.m_41619_() && itemStack2.m_41788_() ? new DeathMessageComponents(DeathMessageUtils.getLocalizedDisplayName((Entity)diedEntity), (Component)Component.m_237113_((String)LocaleProvider.getTranslate(withItem)), killerDisplayName, itemStack2.m_41611_()) : new DeathMessageComponents(DeathMessageUtils.getLocalizedDisplayName((Entity)diedEntity), (Component)Component.m_237113_((String)LocaleProvider.getTranslate(withoutItem)), killerDisplayName, null);
    }

    @Nullable
    private static Component getLocalizedDisplayName(@Nullable Entity entity) {
        TamableAnimal animal;
        if (entity == null) {
            return null;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_5446_();
        }
        if (entity instanceof TamableAnimal && (animal = (TamableAnimal)entity).m_8077_()) {
            return animal.m_5446_();
        }
        return Component.m_237113_((String)LocaleProvider.getTranslate(entity.m_6095_().m_20675_()));
    }

    @Nullable
    private static CombatEntry getMostSignificantFall(List<CombatEntry> entries) {
        CombatEntry combatEntry = null;
        CombatEntry combatEntry2 = null;
        float f = 0.0f;
        float g = 0.0f;
        for (int i = 0; i < entries.size(); ++i) {
            float h;
            CombatEntry combatEntry3 = entries.get(i);
            CombatEntry combatEntry4 = i > 0 ? entries.get(i - 1) : null;
            DamageSource damageSource = combatEntry3.f_19250_();
            boolean bl = damageSource.m_269533_(DamageTypeTags.f_268518_);
            float f2 = h = bl ? Float.MAX_VALUE : combatEntry3.f_19255_();
            if ((damageSource.m_269533_(DamageTypeTags.f_268549_) || bl) && h > 0.0f && (combatEntry == null || h > g)) {
                combatEntry = i > 0 ? combatEntry4 : combatEntry3;
                g = h;
            }
            if (combatEntry3.f_289042_() == null || combatEntry2 != null && !(combatEntry3.f_19252_() > f)) continue;
            combatEntry2 = combatEntry3;
            f = combatEntry3.f_19252_();
        }
        if (g > 5.0f && combatEntry != null) {
            return combatEntry;
        }
        if (f > 5.0f && combatEntry2 != null) {
            return combatEntry2;
        }
        return null;
    }

    public record DeathMessageComponents(Component diedEntityName, Component deathCause, @Nullable Component killerEntity, @Nullable Component item) {
        public DeathMessageComponents(Component diedEntityName, Component deathCause, @Nullable Component killerEntity, @Nullable Component item) {
            deathCause = Component.m_237113_((String)deathCause.getString().replace("%1$s", DeathMessageUtils.DIED_ENTITY_REPLACEMENT_TAG).replace("%2$s", DeathMessageUtils.KILLER_ENTITY_REPLACEMENT_TAG).replace("%3$s", DeathMessageUtils.ITEM_REPLACEMENT_TAG));
        }
    }
}

