/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod;

import com.denisnumb.discord_chat_mod.chat_images.utils.ImageUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.locale.Language;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LocaleProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Map<String, String> LANGUAGE_DATA = new HashMap<String, String>();
    private static final String CACHE_DIR_NAME = "locale_cache";
    private static final String BASE_GITHUB_URL = "https://raw.githubusercontent.com/denisnumb/discord-chat-mod/1.20.1/data/minecraft_locales/";
    private static LocaleLoader localeLoader;

    public static void setLocaleLoader(LocaleLoader impl) {
        localeLoader = impl;
    }

    public static void loadLocalization() {
        if (localeLoader != null) {
            localeLoader.loadLocalization();
        }
    }

    public static String getTranslateClient(String key) {
        return Language.m_128107_().m_6834_(key);
    }

    public static String getTranslate(String key) {
        return LANGUAGE_DATA.containsKey(key) ? LANGUAGE_DATA.get(key) : Language.m_128107_().m_6834_(key);
    }

    public static boolean loadLocaleFromPath(@Nullable Path localePath) {
        try {
            if (localePath != null && Files.exists(localePath, new LinkOption[0])) {
                LocaleProvider.addLanguageData((Map)GSON.fromJson(Files.readString(localePath), TYPE));
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load localization {}", (Object)localePath);
        }
        return false;
    }

    public static void loadMinecraftLocale(String locale) {
        if (LocaleProvider.loadLocaleFromPath(LocaleProvider.getCachedFile(locale))) {
            return;
        }
        String url = String.format(BASE_GITHUB_URL + locale + ".json", new Object[0]);
        try (InputStreamReader reader = new InputStreamReader(ImageUtils.getInputStreamFromUrl(url), StandardCharsets.UTF_8);){
            Map data = (Map)GSON.fromJson((Reader)reader, TYPE);
            LocaleProvider.saveMinecraftLocaleToCache(locale, data);
            LocaleProvider.addLanguageData(data);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load minecraft localization from {}", (Object)url);
            e.printStackTrace();
        }
    }

    private static void addLanguageData(Map<String, String> languageData) {
        LANGUAGE_DATA.putAll(languageData);
    }

    @Nullable
    private static Path getCachedFile(String locale) {
        Path cacheDir = Paths.get(CACHE_DIR_NAME, new String[0]);
        if (!Files.exists(cacheDir, new LinkOption[0])) {
            try {
                Files.createDirectories(cacheDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                return null;
            }
        }
        return cacheDir.resolve(locale + ".json");
    }

    private static void saveMinecraftLocaleToCache(String locale, Map<String, String> data) {
        Path cachedFile = LocaleProvider.getCachedFile(locale);
        if (cachedFile != null) {
            if (Files.exists(cachedFile, new LinkOption[0])) {
                return;
            }
            try {
                Files.writeString(cachedFile, (CharSequence)GSON.toJson(data), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static interface LocaleLoader {
        public void loadLocalization();
    }
}

