/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod;

import com.denisnumb.discord_chat_mod.LocaleProvider;
import com.denisnumb.discord_chat_mod.config.ConfigProvider;
import com.denisnumb.discord_chat_mod.network.emoji.DiscordEmojisTransceiver;
import com.denisnumb.discord_chat_mod.network.mentions.DiscordMentionsTransceiver;
import com.denisnumb.discord_chat_mod.network.sticker.DiscordStickersTransceiver;
import com.shadow.com.vdurmont.emoji.EmojiParser;
import java.io.File;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;

public class MinecraftClientEvents {
    public static Component handleScreenshot(File screenshotFile) {
        MutableComponent screenshotName = Component.m_237113_((String)screenshotFile.getName()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, screenshotFile.getAbsolutePath())));
        MutableComponent clickToSendComponent = Component.m_237113_((String)(" " + LocaleProvider.getTranslateClient("discord_chat_mod.command.send_screenshot.click_to_send"))).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "send_screenshot " + screenshotFile.getAbsolutePath())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)LocaleProvider.getTranslateClient("discord_chat_mod.command.send_screenshot.click_to_send.hint")))));
        return Component.m_237113_((String)LocaleProvider.getTranslateClient("screenshot.success").replace("%s", "")).m_7220_((Component)screenshotName).m_7220_((Component)clickToSendComponent);
    }

    public static Component handleChatMessage(Component message) {
        if (ConfigProvider.getConfig().isEmojifulCompatibilityEnabled() && !EmojiParser.extractEmojis(message.getString()).isEmpty()) {
            MutableComponent withReplacedEmojis = Component.m_237119_();
            for (Component comp : message.m_240407_()) {
                withReplacedEmojis.m_7220_((Component)Component.m_237113_((String)EmojiParser.parseToAliases(comp.getString())).m_130948_(comp.m_7383_()));
            }
            return withReplacedEmojis;
        }
        return message;
    }

    public static void handleJoinServer() {
        DiscordMentionsTransceiver.requestDiscordMemberData();
        DiscordEmojisTransceiver.requestDiscordEmojis();
        DiscordStickersTransceiver.requestDiscordStickers();
    }
}

