/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod;

import com.denisnumb.discord_chat_mod.DeathMessageUtils;
import com.denisnumb.discord_chat_mod.MinecraftUtils;
import com.denisnumb.discord_chat_mod.advancement.AdvancementIconParser;
import com.denisnumb.discord_chat_mod.advancement.AdvancementParser;
import com.denisnumb.discord_chat_mod.chat_style.ChatStyleUtils;
import com.denisnumb.discord_chat_mod.chat_style.MinecraftChatStyleProvider;
import com.denisnumb.discord_chat_mod.commands.MentionCommand;
import com.denisnumb.discord_chat_mod.commands.ReloadConfigCommand;
import com.denisnumb.discord_chat_mod.commands.SendStickerCommand;
import com.denisnumb.discord_chat_mod.commands.set_avatar.SetAvatarCommand;
import com.denisnumb.discord_chat_mod.commands.vanilla.EmoteCommand;
import com.denisnumb.discord_chat_mod.commands.vanilla.MsgCommand;
import com.denisnumb.discord_chat_mod.commands.vanilla.SayCommand;
import com.denisnumb.discord_chat_mod.commands.vanilla.TeamMsgCommand;
import com.denisnumb.discord_chat_mod.commands.vanilla.TellrawCommand;
import com.denisnumb.discord_chat_mod.config.ConfigProvider;
import com.denisnumb.discord_chat_mod.config.IConfigProvider;
import com.denisnumb.discord_chat_mod.discord.DiscordChannelRegistry;
import com.denisnumb.discord_chat_mod.discord.DiscordUtils;
import com.denisnumb.discord_chat_mod.discord.ServerStatusController;
import com.denisnumb.discord_chat_mod.discord.chat_style.DiscordChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.chat_style.MessageType;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;

public class MinecraftEvents {
    public static void handleRegisterCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        MentionCommand.register(dispatcher);
        SendStickerCommand.register(dispatcher);
        ReloadConfigCommand.register(dispatcher);
        SayCommand.register(dispatcher);
        TellrawCommand.register(dispatcher, context);
        MsgCommand.register(dispatcher);
        EmoteCommand.register(dispatcher);
        TeamMsgCommand.register(dispatcher);
        IConfigProvider config = ConfigProvider.getConfig();
        if (config.isWebhookModeEnabled() && config.isSetAvatarUrlCommandEnabled()) {
            SetAvatarCommand.register(dispatcher);
        }
    }

    public static Component handleChatMessageText(ServerPlayer player, Component component) {
        MinecraftUtils.ProcessChatMessageResult chatMessage = MinecraftUtils.processChatMessage(component.getString(), ChannelCategory.PLAYER_CHAT);
        DiscordUtils.handleDiscord(() -> {
            Map<String, String> parameters = ChatStyleUtils.mergeMaps(Map.of("{message}", chatMessage.forDiscord()), DiscordChatStyleProvider.buildPlayerParameters((Entity)player));
            Optional<DiscordChatStyleProvider.DiscordMessageComponents> chatComponentsOpt = DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.CHAT, parameters);
            Optional<DiscordChatStyleProvider.DiscordMessageComponents> webhookComponentsOpt = DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.CHAT_WEBHOOK, parameters);
            if (chatComponentsOpt.isPresent() && webhookComponentsOpt.isPresent()) {
                DiscordUtils.sendMessageFromPlayer(ChannelCategory.PLAYER_CHAT, DiscordChannelRegistry.getAllContexts(), (Player)player, webhookComponentsOpt.get(), chatComponentsOpt.get());
            }
        });
        return chatMessage.forMinecraft();
    }

    public static Optional<Component> handleChatMessage(ResourceKey<ChatType> chatType, MinecraftChatStyleProvider.ChatMessageComponents components) {
        if (ConfigProvider.getConfig().isMinecraftChatCustomizationEnabled()) {
            return MinecraftChatStyleProvider.getStyledChatMessage(chatType, components);
        }
        return Optional.empty();
    }

    public static Optional<Component> handlePlayerOrPetDie(List<CombatEntry> combatEntries, LivingEntity entity) {
        TamableAnimal a;
        if (!(entity instanceof Player || entity instanceof TamableAnimal && (a = (TamableAnimal)entity).m_21824_())) {
            return Optional.empty();
        }
        DeathMessageUtils.DeathMessageComponents components = DeathMessageUtils.getDeathMessageComponents(combatEntries, entity);
        if (entity instanceof Player) {
            DiscordUtils.handleDiscord(() -> {
                Map<String, String> parameters = ChatStyleUtils.mergeMaps(Map.of("{death_message}", DiscordChatStyleProvider.formatDeathMessageComponents(components)), DiscordChatStyleProvider.buildPlayerParameters(components.diedEntityName().getString(), (Entity)entity));
                DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.DEATH, parameters).ifPresent(discordMessageComponents -> DiscordUtils.sendMessageFromServer(ChannelCategory.DEATHS, DiscordChannelRegistry.getAllContexts(), discordMessageComponents));
            });
        }
        if (ConfigProvider.getConfig().isMinecraftChatCustomizationEnabled()) {
            return MinecraftChatStyleProvider.getStyledDeathMessage(components);
        }
        return Optional.empty();
    }

    public static Optional<Component> handleAdvancementMade(Player player, Advancement advancement) {
        if (advancement.m_138320_() == null) {
            return Optional.empty();
        }
        DisplayInfo displayInfo = advancement.m_138320_();
        if (!displayInfo.m_14996_()) {
            return Optional.empty();
        }
        ResourceLocation advancementId = advancement.m_138327_();
        ResourceLocation advancementResourceLocation = new ResourceLocation(advancementId.m_135827_(), "advancements/" + advancementId.m_135815_() + ".json");
        String title = displayInfo.m_14977_().getString();
        String description = displayInfo.m_14985_().getString();
        JsonObject advancementJson = AdvancementParser.getAdvancementFileAsJsonObject(advancementResourceLocation);
        if (advancementJson != null) {
            title = AdvancementParser.getTranslatedAdvancementTitle(advancementJson, title);
            description = AdvancementParser.getTranslatedAdvancementDescription(advancementJson, description);
        }
        String finalTitle = title;
        String finalDescription = description;
        DiscordUtils.handleDiscord(() -> {
            MessageType messageType = switch (displayInfo.m_14992_()) {
                default -> throw new IncompatibleClassChangeError();
                case FrameType.TASK -> MessageType.ADVANCEMENT_TASK;
                case FrameType.CHALLENGE -> MessageType.ADVANCEMENT_CHALLENGE;
                case FrameType.GOAL -> MessageType.ADVANCEMENT_GOAL;
            };
            Map<String, String> parameters = ChatStyleUtils.mergeMaps(Map.of("{advancement}", finalTitle, "{description}", finalDescription, "{icon_url}", "attachment://icon.png"), DiscordChatStyleProvider.buildPlayerParameters((Entity)player));
            DiscordChatStyleProvider.getDiscordMessageComponents(messageType, parameters).ifPresent(components -> AdvancementIconParser.parseAdvancementIcon(displayInfo).ifPresentOrElse(iconData -> DiscordUtils.sendMessageFromServer(ChannelCategory.ADVANCEMENTS, DiscordChannelRegistry.getAllContexts(), components, iconData), () -> DiscordUtils.sendMessageFromServer(ChannelCategory.ADVANCEMENTS, DiscordChannelRegistry.getAllContexts(), components)));
        });
        if (ConfigProvider.getConfig().isMinecraftChatCustomizationEnabled()) {
            return MinecraftChatStyleProvider.getStyledAdvancementMessage(player, advancement, title, description);
        }
        return Optional.empty();
    }

    public static Optional<Component> handleJoinLeave(Player player, boolean isJoin) {
        DiscordUtils.handleDiscord(() -> {
            MessageType messageType = isJoin ? MessageType.JOIN : MessageType.LEFT;
            DiscordChatStyleProvider.getDiscordMessageComponents(messageType, DiscordChatStyleProvider.buildPlayerParameters((Entity)player)).ifPresent(components -> DiscordUtils.sendMessageFromServer(ChannelCategory.PLAYER_JOIN_LEAVE, DiscordChannelRegistry.getAllContexts(), components));
            ServerStatusController.updateServerStatusWithDelay();
        });
        if (ConfigProvider.getConfig().isMinecraftChatCustomizationEnabled()) {
            return MinecraftChatStyleProvider.getStyledJoinedLeftMessage(player, isJoin);
        }
        return Optional.empty();
    }
}

