/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod;

import com.denisnumb.discord_chat_mod.DiscordChatMod;
import com.denisnumb.discord_chat_mod.discord.DiscordChannelRegistry;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class ServerLogsRetranslator {
    private static boolean DO_LOGGING = false;

    public static void init(String loggingLevel) {
        DiscordLogBuffer.init();
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withPattern("[%d{HH:mm:ss}] [%t/%level] (%logger{1}) %msg%n").build();
        AbstractAppender appender = new AbstractAppender("DiscordAppender", null, (Layout)layout, false, null){

            public void append(LogEvent event) {
                if (DO_LOGGING) {
                    DiscordLogBuffer.add(new String(this.getLayout().toByteArray(event)));
                }
            }
        };
        Level level = switch (loggingLevel) {
            case "ERROR" -> Level.ERROR;
            case "WARN" -> Level.WARN;
            default -> Level.INFO;
        };
        appender.start();
        config.getRootLogger().addAppender((Appender)appender, level, null);
        ctx.updateLoggers();
    }

    private static void sendLogsToDiscord(String logs) {
        if (logs == null || ((String)logs).isEmpty()) {
            return;
        }
        if (((String)logs).length() > 2000) {
            logs = ((String)logs).substring(0, 1990) + ". . .";
        }
        if (!DiscordChannelRegistry.isChannelCategoryDisabled(DiscordChannelRegistry.serverLogsChannel) && DiscordChatMod.isDiscordConnected()) {
            try {
                DiscordChannelRegistry.serverLogsChannel.sendMessage(String.format("```cmd\n%s\n```", logs)).queue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void start() {
        DO_LOGGING = true;
    }

    public static void stop() {
        DiscordLogBuffer.shutdown();
        DO_LOGGING = false;
    }

    static class DiscordLogBuffer {
        private static final int MAX_LENGTH = 2000;
        private static final long MAX_DELAY_MS = 10000L;
        private static final long MIN_SEND_INTERVAL_MS = 2000L;
        private static final StringBuilder buffer = new StringBuilder();
        private static final Object lock = new Object();
        private static Instant lastSend = Instant.now();
        private static ScheduledExecutorService scheduler;

        DiscordLogBuffer() {
        }

        public static void init() {
            scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread t = new Thread(r, "ServerLogsRetranslatorThread");
                t.setDaemon(true);
                return t;
            });
            scheduler.scheduleAtFixedRate(DiscordLogBuffer::checkAndFlush, 2L, 2L, TimeUnit.SECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void add(String message) {
            Object object = lock;
            synchronized (object) {
                buffer.append(message).append("\n");
                long elapsed = Instant.now().toEpochMilli() - lastSend.toEpochMilli();
                if (elapsed < 2000L) {
                    return;
                }
                if (buffer.length() >= 2000) {
                    DiscordLogBuffer.flushLimited();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void checkAndFlush() {
            Object object = lock;
            synchronized (object) {
                if (buffer.isEmpty()) {
                    return;
                }
                long elapsed = Instant.now().toEpochMilli() - lastSend.toEpochMilli();
                if (elapsed > 10000L) {
                    DiscordLogBuffer.flushFull();
                    return;
                }
                if (elapsed >= 2000L) {
                    if (buffer.length() > 2000) {
                        DiscordLogBuffer.flushLimited();
                    } else {
                        DiscordLogBuffer.flushFull();
                    }
                }
            }
        }

        private static void flushLimited() {
            String content = buffer.substring(0, 2000);
            buffer.delete(0, 2000);
            lastSend = Instant.now();
            CompletableFuture.runAsync(() -> ServerLogsRetranslator.sendLogsToDiscord(content));
        }

        private static void flushFull() {
            if (buffer.isEmpty()) {
                return;
            }
            String content = buffer.toString();
            buffer.setLength(0);
            lastSend = Instant.now();
            CompletableFuture.runAsync(() -> ServerLogsRetranslator.sendLogsToDiscord(content));
        }

        public static void shutdown() {
            if (scheduler == null) {
                return;
            }
            try {
                DiscordLogBuffer.flushFull();
                scheduler.shutdown();
                if (!scheduler.awaitTermination(3L, TimeUnit.SECONDS)) {
                    scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                scheduler.shutdownNow();
            }
        }
    }
}

