/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.advancement;

import com.denisnumb.discord_chat_mod.DiscordChatMod;
import com.denisnumb.discord_chat_mod.chat_images.utils.ImageUtils;
import com.denisnumb.discord_chat_mod.discord.DiscordUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AdvancementIconParser {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();

    private static String resolveItemTexture(String namespace, String name) throws IOException {
        return AdvancementIconParser.resolveModelTexture(String.format("/assets/%s/models/item/%s.json", namespace, name), namespace, name);
    }

    private static String resolveModelTexture(String modelPath, String namespace, String defaultName) throws IOException {
        try (InputStream input = AdvancementIconParser.getResourceAsStream(modelPath);){
            if (input == null) {
                String string = defaultName;
                return string;
            }
            JsonObject modelJson = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(input), JsonObject.class);
            if (modelJson.has("textures")) {
                JsonObject textures = modelJson.getAsJsonObject("textures");
                for (Map.Entry entry : textures.entrySet()) {
                    String tex = ((JsonElement)entry.getValue()).getAsString();
                    if (tex.startsWith("#")) continue;
                    String[] parts = tex.split("/");
                    String string = parts[parts.length - 1];
                    return string;
                }
            }
            if (modelJson.has("parent")) {
                Object parent = modelJson.get("parent").getAsString();
                if (!((String)parent).contains(":")) {
                    parent = namespace + ":" + (String)parent;
                }
                String[] parts = ((String)parent).split(":");
                String parentNamespace = parts[0];
                String parentPath = parts[1];
                String string = AdvancementIconParser.resolveModelTexture(String.format("/assets/%s/models/%s.json", parentNamespace, parentPath), namespace, defaultName);
                return string;
            }
        }
        return defaultName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<DiscordUtils.ImageData> parseAdvancementIcon(DisplayInfo displayInfo) {
        try {
            ItemStack stack = displayInfo.m_14990_();
            ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
            String namespace = id.m_135827_();
            String name = id.m_135815_();
            String textureName = AdvancementIconParser.resolveItemTexture(namespace, name);
            if (textureName.equals(name)) {
                textureName = AdvancementIconParser.resolveModelTexture(String.format("/assets/%s/models/block/%s.json", namespace, name), namespace, name);
            }
            try (InputStream input = AdvancementIconParser.getResourceAsStream(String.format("/assets/%s/textures/item/%s.png", namespace, textureName));){
                if (input != null) {
                    Optional<DiscordUtils.ImageData> optional2 = Optional.of(new DiscordUtils.ImageData("icon.png", ImageUtils.scaleImage(input.readAllBytes(), 3.0)));
                    return optional2;
                }
            }
            input = AdvancementIconParser.getResourceAsStream(String.format("/assets/%s/textures/block/%s.png", namespace, textureName));
            try {
                if (input == null) return Optional.empty();
                Optional<DiscordUtils.ImageData> optional = Optional.of(new DiscordUtils.ImageData("icon.png", ImageUtils.scaleImage(input.readAllBytes(), 3.0)));
                return optional;
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("AdvancementIconParseError [{}]: {}", (Object)displayInfo.m_14990_().m_41778_(), (Object)e.getMessage());
        }
        return Optional.empty();
    }

    @Nullable
    private static InputStream getResourceAsStream(String path) {
        InputStream input = DiscordChatMod.class.getResourceAsStream(path);
        if (input != null) {
            return input;
        }
        return DiscordChatMod.class.getClassLoader().getResourceAsStream(path);
    }
}

