/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.chat_images;

import com.denisnumb.discord_chat_mod.DiscordChatMod;
import com.denisnumb.discord_chat_mod.chat_images.model.AbstractImage;
import com.denisnumb.discord_chat_mod.chat_images.model.AnimatedImage;
import com.denisnumb.discord_chat_mod.chat_images.model.Image;
import com.denisnumb.discord_chat_mod.chat_images.model.ImageSize;
import com.denisnumb.discord_chat_mod.chat_images.model.LoadResult;
import com.denisnumb.discord_chat_mod.chat_images.utils.GifUtils;
import com.denisnumb.discord_chat_mod.chat_images.utils.ImageUtils;
import com.denisnumb.discord_chat_mod.chat_images.utils.WebpUtils;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ImageStorage {
    public static final float MAX_WIDTH = 128.0f;
    public static final float MAX_HEIGHT = 72.0f;
    public static final Map<String, AbstractImage> IMAGE_CACHE = new HashMap<String, AbstractImage>();
    public static final Set<String> HANDLED_URLS = new HashSet<String>();
    private static CompletableFuture<LoadResult> lastTask = CompletableFuture.completedFuture(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompletableFuture<LoadResult> loadImagesParallel(List<String> urls2, Supplier<Integer> trimmedSize, Supplier<Integer> allSize) {
        Class<ImageStorage> clazz = ImageStorage.class;
        synchronized (ImageStorage.class) {
            lastTask = lastTask.thenComposeAsync(ignored -> ImageStorage.runLoadImages(urls2, (Integer)trimmedSize.get(), (Integer)allSize.get()));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return lastTask;
        }
    }

    private static CompletableFuture<LoadResult> runLoadImages(List<String> urls2, int trimmedSize, int allSize) {
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        List<CompletableFuture> futures = urls2.stream().distinct().map(url -> CompletableFuture.supplyAsync(() -> ImageStorage.parseImage(url), executor)).toList();
        return ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> new LoadResult(trimmedSize, allSize, urls2.stream().map(ImageStorage::parseImage).toList()))).whenComplete((res, ex) -> executor.shutdown());
    }

    @Nullable
    public static AbstractImage parseEmojiOrSticker(String url) {
        return ImageStorage.parseImageInternal(url, false);
    }

    @Nullable
    private static AbstractImage parseImage(String url) {
        return ImageStorage.parseImageInternal(url, true);
    }

    @Nullable
    private static AbstractImage parseImageInternal(String url, boolean skipHandledUrls) {
        String mimeType;
        if (IMAGE_CACHE.containsKey(url)) {
            return IMAGE_CACHE.get(url);
        }
        if (skipHandledUrls && HANDLED_URLS.contains(url)) {
            return null;
        }
        if (skipHandledUrls) {
            HANDLED_URLS.add(url);
        }
        if (ImageUtils.isImageUrl(mimeType = ImageUtils.getMimeType(url)) || ImageUtils.isTenorGifUrl(url)) {
            try {
                ImageStorage.loadImageFromUrl(url, mimeType);
                return ImageStorage.parseImageInternal(url, skipHandledUrls);
            }
            catch (Exception e) {
                DiscordChatMod.LOGGER.error("ImageLoadError: {}", (Object)e.getMessage());
            }
        } else if (ImageUtils.isLocalResourceUrl(url)) {
            return ImageUtils.waitForLocalResource(IMAGE_CACHE, url, 15000L, 50L);
        }
        return null;
    }

    public static void registerImage(String imageUrl, byte[] imageBytes) throws IOException, InterruptedException {
        NativeImage nativeImage = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(imageBytes));
        boolean isSpoiler = ImageUtils.isSpoilerImageUrl(imageUrl);
        ResourceLocation spoilerTextureLocation = isSpoiler ? ImageStorage.registerSpoilerImage(imageUrl, NativeImage.m_85058_((InputStream)new ByteArrayInputStream(imageBytes))) : null;
        ResourceLocation textureLocation = new ResourceLocation("discord_chat_mod/chat_image/" + imageUrl.hashCode());
        CountDownLatch latch = new CountDownLatch(1);
        RenderSystem.recordRenderCall(() -> {
            try {
                Minecraft.m_91087_().m_91097_().m_118495_(textureLocation, (AbstractTexture)new DynamicTexture(nativeImage));
            }
            finally {
                latch.countDown();
            }
        });
        latch.await();
        IMAGE_CACHE.put(imageUrl, new Image(imageUrl, ImageUtils.getImageScaledSize(nativeImage.m_84982_(), nativeImage.m_85084_()), new ImageSize(nativeImage.m_84982_(), nativeImage.m_85084_()), textureLocation, isSpoiler, spoilerTextureLocation));
    }

    private static void loadImageFromUrl(String imageUrl, String mimeType) throws Exception {
        if (ImageUtils.isTenorGifUrl(imageUrl) || ImageUtils.isGifUrl(mimeType)) {
            ImageStorage.loadGifFromUrl(imageUrl);
        } else if (WebpUtils.isAnimatedWebpUrl(imageUrl, mimeType)) {
            ImageStorage.loadWebpAnimatedWebpFromUrl(imageUrl);
        } else {
            try (InputStream inputStream2 = ImageUtils.getInputStreamFromUrl(imageUrl);){
                ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)ImageIO.read(inputStream2), "png", outputStream2);
                ImageStorage.registerImage(imageUrl, outputStream2.toByteArray());
            }
        }
    }

    private static void loadWebpAnimatedWebpFromUrl(String webpUrl) throws Exception {
        List<WebpUtils.FrameMetadata> frameMetadata;
        byte[] webpData;
        ArrayList<ResourceLocation> frames = new ArrayList<ResourceLocation>();
        ImageSize frameSize = null;
        int frameDuration = -1;
        boolean isSpoiler = ImageUtils.isSpoilerImageUrl(webpUrl);
        ResourceLocation spoilerTextureLocation = null;
        try (InputStream input = ImageUtils.getInputStreamFromUrl(webpUrl);){
            webpData = input.readAllBytes();
        }
        try (ByteArrayInputStream metaStream = new ByteArrayInputStream(webpData);){
            frameMetadata = WebpUtils.parseAnimatedWebP(metaStream);
        }
        try (ImageInputStream input = ImageIO.createImageInputStream(new ByteArrayInputStream(webpData));){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
            if (!readers.hasNext()) {
                throw new IllegalStateException("No ImageReader for WebP");
            }
            ImageReader reader = readers.next();
            reader.setInput(input);
            int frameCount = reader.getNumImages(true);
            BufferedImage canvas = new BufferedImage(reader.getWidth(0), reader.getHeight(0), 2);
            Graphics2D g = canvas.createGraphics();
            CountDownLatch latch = new CountDownLatch(frameCount);
            for (int i = 0; i < frameCount; ++i) {
                BufferedImage frame = reader.read(i);
                WebpUtils.FrameMetadata meta = i < frameMetadata.size() ? frameMetadata.get(i) : new WebpUtils.FrameMetadata(0, 0, frame.getWidth(), frame.getHeight());
                g.drawImage((java.awt.Image)frame, meta.xOffset(), meta.yOffset(), null);
                ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)canvas, "png", outputStream2);
                byte[] imageBytes = outputStream2.toByteArray();
                if (i == 0) {
                    frameSize = new ImageSize(frame.getWidth(), frame.getHeight());
                    frameDuration = 100;
                    if (isSpoiler) {
                        spoilerTextureLocation = ImageStorage.registerSpoilerImage(webpUrl, NativeImage.m_85058_((InputStream)new ByteArrayInputStream(imageBytes)));
                    }
                }
                ResourceLocation frameLocation = new ResourceLocation("discord_chat_mod/chat_webp/" + webpUrl.hashCode() + "_" + i);
                NativeImage nativeImage = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(imageBytes));
                RenderSystem.recordRenderCall(() -> {
                    try {
                        Minecraft.m_91087_().m_91097_().m_118495_(frameLocation, (AbstractTexture)new DynamicTexture(nativeImage));
                    }
                    finally {
                        latch.countDown();
                    }
                });
                frames.add(frameLocation);
            }
            g.dispose();
            reader.dispose();
            latch.await();
            if (!frames.isEmpty()) {
                IMAGE_CACHE.put(webpUrl, new AnimatedImage(webpUrl, frames, ImageUtils.getImageScaledSize(frameSize.width(), frameSize.height()), frameSize, frameDuration, isSpoiler, spoilerTextureLocation));
            }
        }
    }

    private static void loadGifFromUrl(String gifUrl) throws Exception {
        String cacheKey = gifUrl;
        if (ImageUtils.isTenorGifUrl(gifUrl)) {
            gifUrl = GifUtils.getTenorGifSourceUrl(gifUrl);
        }
        ArrayList<ResourceLocation> frames = new ArrayList<ResourceLocation>();
        ImageSize frameSize = null;
        int frameDuration = -1;
        boolean isSpoiler = ImageUtils.isSpoilerImageUrl(gifUrl);
        ResourceLocation spoilerTextureLocation = null;
        try (ImageInputStream input = ImageIO.createImageInputStream(ImageUtils.getInputStreamFromUrl(gifUrl));){
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("gif");
            if (!readers.hasNext()) {
                throw new IOException("No GIF reader found");
            }
            ImageReader reader = readers.next();
            reader.setInput(input);
            int numFrames = reader.getNumImages(true);
            CountDownLatch latch = new CountDownLatch(numFrames);
            int width = reader.getWidth(0);
            int height = reader.getHeight(0);
            BufferedImage canvas = new BufferedImage(width, height, 2);
            Graphics2D g2d = canvas.createGraphics();
            g2d.setBackground(new Color(0, 0, 0, 0));
            g2d.clearRect(0, 0, width, height);
            BufferedImage savedCanvas = null;
            for (int i = 0; i < numFrames; ++i) {
                String disposal;
                BufferedImage frame = reader.read(i);
                IIOMetadata metadata = reader.getImageMetadata(i);
                Rectangle frameRect = GifUtils.getFrameRect(metadata);
                switch (disposal = GifUtils.getDisposalMethod(metadata)) {
                    case "restoreToPrevious": {
                        savedCanvas = GifUtils.bufferedImageDeepCopy(canvas);
                        break;
                    }
                    case "restoreToBackgroundColor": {
                        GifUtils.clearBufferedImageArea(canvas, frameRect);
                    }
                }
                Graphics2D g = canvas.createGraphics();
                g.drawImage((java.awt.Image)frame, frameRect.x, frameRect.y, null);
                g.dispose();
                if ("restoreToPrevious".equals(disposal) && savedCanvas != null) {
                    Graphics2D gRestore = canvas.createGraphics();
                    gRestore.drawImage((java.awt.Image)savedCanvas, 0, 0, null);
                    gRestore.dispose();
                }
                ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)canvas, "png", outputStream2);
                byte[] imageBytes = outputStream2.toByteArray();
                if (i == 0) {
                    frameSize = new ImageSize(frame.getWidth(), frame.getHeight());
                    frameDuration = GifUtils.getGifFrameDuration(metadata);
                    if (isSpoiler) {
                        spoilerTextureLocation = ImageStorage.registerSpoilerImage(gifUrl, NativeImage.m_85058_((InputStream)new ByteArrayInputStream(imageBytes)));
                    }
                }
                ResourceLocation frameLocation = new ResourceLocation("discord_chat_mod/chat_gif/" + gifUrl.hashCode() + "_" + i);
                NativeImage nativeImage = NativeImage.m_85058_((InputStream)new ByteArrayInputStream(imageBytes));
                RenderSystem.recordRenderCall(() -> {
                    try {
                        Minecraft.m_91087_().m_91097_().m_118495_(frameLocation, (AbstractTexture)new DynamicTexture(nativeImage));
                    }
                    finally {
                        latch.countDown();
                    }
                });
                frames.add(frameLocation);
            }
            g2d.dispose();
            reader.dispose();
            latch.await();
            if (!frames.isEmpty()) {
                IMAGE_CACHE.put(cacheKey, new AnimatedImage(cacheKey, frames, ImageUtils.getImageScaledSize(frameSize.width(), frameSize.height()), frameSize, Math.max(frameDuration, 100), isSpoiler, spoilerTextureLocation));
            }
        }
    }

    private static ResourceLocation registerSpoilerImage(String imageUrl, NativeImage image) throws InterruptedException {
        ImageUtils.applyPixelation(image, image.m_85084_() / 6);
        ImageUtils.applySpoilerOverlay(image);
        ResourceLocation spoilerTextureLocation = new ResourceLocation("discord_chat_mod/chat_image_spoiler/" + imageUrl.hashCode());
        CountDownLatch latch = new CountDownLatch(1);
        RenderSystem.recordRenderCall(() -> {
            try {
                Minecraft.m_91087_().m_91097_().m_118495_(spoilerTextureLocation, (AbstractTexture)new DynamicTexture(image));
            }
            finally {
                latch.countDown();
            }
        });
        latch.await();
        return spoilerTextureLocation;
    }
}

