/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.chat_images.utils;

import com.denisnumb.discord_chat_mod.chat_images.model.ImageSize;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.Nullable;

public class ImageUtils {
    public static final String SPOILER_PREFIX = "/SPOILER_";
    public static final String LOCAL_RESOURCE_PREFIX = "localResource://";

    public static boolean isTenorGifUrl(String url) {
        return url.startsWith("https://tenor.com/");
    }

    public static boolean isImageUrl(String mimeType) {
        return mimeType.matches("(?i)^image/(png|jpeg|jpg|gif|bmp|webp)$");
    }

    public static boolean isGifUrl(String mimeType) {
        return mimeType.equalsIgnoreCase("image/gif");
    }

    public static String getMimeType(String url) {
        if (url.isEmpty()) {
            return "";
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)new URI(url).toURL().openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            connection.setRequestMethod("HEAD");
            connection.connect();
            String contentType = connection.getContentType();
            return contentType == null ? "" : contentType;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static InputStream getInputStreamFromUrl(String url) throws IOException, URISyntaxException {
        HttpURLConnection conn = (HttpURLConnection)new URI(url).toURL().openConnection();
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36");
        return conn.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static <K, V> V waitForLocalResource(Map<K, V> map, K key, long timeoutMillis, long pollIntervalMillis) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < timeoutMillis) {
            Map<K, V> map2 = map;
            synchronized (map2) {
                if (map.containsKey(key)) {
                    return map.get(key);
                }
            }
            try {
                Thread.sleep(pollIntervalMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        return null;
    }

    public static boolean isLocalResourceUrl(String imageUrl) {
        return imageUrl.startsWith(LOCAL_RESOURCE_PREFIX);
    }

    public static boolean isSpoilerImageUrl(String imageUrl) {
        return imageUrl.contains(SPOILER_PREFIX);
    }

    public static ImageSize getImageScaledSize(int width, int height) {
        if ((float)width > 128.0f || (float)height > 72.0f) {
            float imageScale = Math.min(128.0f / (float)width, 72.0f / (float)height);
            width = (int)((float)width * imageScale);
            height = (int)((float)height * imageScale);
        }
        return new ImageSize(width, height);
    }

    public static byte[] scaleImage(byte[] originalBytes, double scale) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(originalBytes);){
            byte[] byArray;
            BufferedImage original = ImageIO.read(bais);
            if (original == null) {
                throw new IOException("Invalid image data");
            }
            int newWidth = (int)Math.round((double)original.getWidth() * scale);
            int newHeight = (int)Math.round((double)original.getHeight() * scale);
            BufferedImage scaled = new BufferedImage(newWidth, newHeight, 2);
            Graphics2D g = scaled.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g.drawImage(original, 0, 0, newWidth, newHeight, null);
            g.dispose();
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)scaled, "png", baos);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public static void applyPixelation(NativeImage image, int pixelSize) {
        int color;
        int y;
        if (pixelSize <= 1) {
            return;
        }
        int width = image.m_84982_();
        int height = image.m_85084_();
        NativeImage small = new NativeImage(width / pixelSize, height / pixelSize, false);
        for (y = 0; y < small.m_85084_(); ++y) {
            for (int x = 0; x < small.m_84982_(); ++x) {
                int srcX = x * pixelSize + pixelSize / 2;
                int srcY = y * pixelSize + pixelSize / 2;
                srcX = Math.min(srcX, width - 1);
                srcY = Math.min(srcY, height - 1);
                color = image.m_84985_(srcX, srcY);
                small.m_84988_(x, y, color);
            }
        }
        for (y = 0; y < height; ++y) {
            int srcY = y / pixelSize;
            for (int x = 0; x < width; ++x) {
                int srcX = x / pixelSize;
                srcX = Math.min(srcX, small.m_84982_() - 1);
                srcY = Math.min(srcY, small.m_85084_() - 1);
                color = small.m_84985_(srcX, srcY);
                image.m_84988_(x, y, color);
            }
        }
        small.close();
    }

    public static void applySpoilerOverlay(NativeImage image) {
        int height;
        int width = image.m_84982_();
        float scale = width >= (height = image.m_85084_()) ? 0.65f : 0.85f;
        int boxWidth = (int)((float)width * scale);
        int boxHeight = (int)((float)height * 0.25f);
        int startX = (width - boxWidth) / 2;
        int startY = (height - boxHeight) / 2;
        int radius = Math.min(boxWidth, boxHeight) / 2;
        int overlayColor = ImageUtils.argb(149, 0, 0, 0);
        for (int y = 0; y < boxHeight; ++y) {
            for (int x = 0; x < boxWidth; ++x) {
                if (!ImageUtils.isInsideRoundedRect(x, y, boxWidth, boxHeight, radius)) continue;
                int px = startX + x;
                int py = startY + y;
                if (px < 0 || px >= width || py < 0 || py >= height) continue;
                int baseColor = image.m_84985_(px, py);
                int blended = ImageUtils.blendARGB(baseColor, overlayColor);
                image.m_84988_(px, py, blended);
            }
        }
    }

    private static boolean isInsideRoundedRect(int x, int y, int width, int height, int radius) {
        if (x >= radius && x < width - radius && y >= 0 && y < height) {
            return true;
        }
        if (y >= radius && y < height - radius && x >= 0 && x < width) {
            return true;
        }
        int dx = radius - x;
        int dy = radius - y;
        if (x < radius && y < radius && dx * dx + dy * dy <= radius * radius) {
            return true;
        }
        dx = x - (width - radius - 1);
        dy = radius - y;
        if (x >= width - radius && y < radius && dx * dx + dy * dy <= radius * radius) {
            return true;
        }
        dx = radius - x;
        dy = y - (height - radius - 1);
        if (x < radius && y >= height - radius && dx * dx + dy * dy <= radius * radius) {
            return true;
        }
        dx = x - (width - radius - 1);
        dy = y - (height - radius - 1);
        return x >= width - radius && y >= height - radius && dx * dx + dy * dy <= radius * radius;
    }

    private static int argb(int a, int r, int g, int b) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    private static int blendARGB(int base, int overlay) {
        int baseA = base >> 24 & 0xFF;
        int baseR = base >> 16 & 0xFF;
        int baseG = base >> 8 & 0xFF;
        int baseB = base & 0xFF;
        int overlayA = overlay >> 24 & 0xFF;
        int overlayR = overlay >> 16 & 0xFF;
        int overlayG = overlay >> 8 & 0xFF;
        int overlayB = overlay & 0xFF;
        float alpha = (float)overlayA / 255.0f;
        int outR = (int)((float)overlayR * alpha + (float)baseR * (1.0f - alpha));
        int outG = (int)((float)overlayG * alpha + (float)baseG * (1.0f - alpha));
        int outB = (int)((float)overlayB * alpha + (float)baseB * (1.0f - alpha));
        return ImageUtils.argb(baseA, outR, outG, outB);
    }
}

