/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.chat_images.utils;

import com.denisnumb.discord_chat_mod.chat_images.utils.ImageUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class WebpUtils {
    private static int readLittleEndian3Bytes(byte[] data, int offset) {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16;
    }

    public static List<FrameMetadata> parseAnimatedWebP(InputStream inputStream2) throws IOException {
        int chunkSize;
        ArrayList<FrameMetadata> frames = new ArrayList<FrameMetadata>();
        byte[] data = inputStream2.readAllBytes();
        for (int offset = 12; offset < data.length - 8; offset += 8 + chunkSize + chunkSize % 2) {
            String chunkId = new String(data, offset, 4);
            chunkSize = ByteBuffer.wrap(data, offset + 4, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
            if (!chunkId.equals("ANMF")) continue;
            byte[] frameData = Arrays.copyOfRange(data, offset + 8, offset + 20);
            int xOffset = WebpUtils.readLittleEndian3Bytes(frameData, 0) * 2;
            int yOffset = WebpUtils.readLittleEndian3Bytes(frameData, 3) * 2;
            int width = WebpUtils.readLittleEndian3Bytes(frameData, 6) + 1;
            int height = WebpUtils.readLittleEndian3Bytes(frameData, 9) + 1;
            frames.add(new FrameMetadata(xOffset, yOffset, width, height));
        }
        return frames;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isAnimatedWebpUrl(String url, String mimeType) {
        if (!mimeType.equalsIgnoreCase("image/webp")) {
            return false;
        }
        try (InputStream input = ImageUtils.getInputStreamFromUrl(url);){
            boolean bl;
            block16: {
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(input);
                try {
                    Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("webp");
                    if (!readers.hasNext()) {
                        throw new RuntimeException("WebP ImageReader not found!");
                    }
                    ImageReader reader = readers.next();
                    reader.setInput(imageInputStream);
                    boolean animated = reader.getNumImages(true) > 1;
                    reader.dispose();
                    bl = animated;
                    if (imageInputStream == null) break block16;
                }
                catch (Throwable throwable) {
                    if (imageInputStream != null) {
                        try {
                            imageInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                imageInputStream.close();
            }
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public record FrameMetadata(int xOffset, int yOffset, int width, int height) {
    }
}

