/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.chat_style;

import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ChatTypeDecoration;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class CustomChatTypeRegistry {
    public static ResourceKey<ChatType> CHAT;
    public static ResourceKey<ChatType> SAY_COMMAND;
    public static ResourceKey<ChatType> MSG_COMMAND_INCOMING;
    public static ResourceKey<ChatType> MSG_COMMAND_OUTGOING;
    public static ResourceKey<ChatType> TEAM_MSG_COMMAND_INCOMING;
    public static ResourceKey<ChatType> TEAM_MSG_COMMAND_OUTGOING;
    public static ResourceKey<ChatType> EMOTE_COMMAND;
    public static final String CHAT_PATH = "chat";
    public static final String SAY_COMMAND_PATH = "say_command";
    public static final String EMOTE_COMMAND_PATH = "emote_command";
    public static final String MSG_COMMAND_INCOMING_PATH = "msg_command_incoming";
    public static final String MSG_COMMAND_OUTGOING_PATH = "msg_command_outgoing";
    public static final String TEAM_MSG_COMMAND_INCOMING_PATH = "team_msg_command_incoming";
    public static final String TEAM_MSG_COMMAND_OUTGOING_PATH = "team_msg_command_outgoing";

    public static void registerChatTypes(Registry<ChatType> registry) {
        CHAT = ResourceKey.m_135785_((ResourceKey)Registries.f_256873_, (ResourceLocation)new ResourceLocation("discord_chat_mod", CHAT_PATH));
        Registry.m_194579_(registry, CHAT, (Object)CustomChatTypeRegistry.buildChatType(CHAT));
        SAY_COMMAND = ResourceKey.m_135785_((ResourceKey)Registries.f_256873_, (ResourceLocation)new ResourceLocation("discord_chat_mod", SAY_COMMAND_PATH));
        Registry.m_194579_(registry, SAY_COMMAND, (Object)CustomChatTypeRegistry.buildChatType(SAY_COMMAND));
        EMOTE_COMMAND = ResourceKey.m_135785_((ResourceKey)Registries.f_256873_, (ResourceLocation)new ResourceLocation("discord_chat_mod", EMOTE_COMMAND_PATH));
        Registry.m_194579_(registry, EMOTE_COMMAND, (Object)CustomChatTypeRegistry.buildChatType(EMOTE_COMMAND));
        MSG_COMMAND_INCOMING = ResourceKey.m_135785_((ResourceKey)Registries.f_256873_, (ResourceLocation)new ResourceLocation("discord_chat_mod", MSG_COMMAND_INCOMING_PATH));
        Registry.m_194579_(registry, MSG_COMMAND_INCOMING, (Object)CustomChatTypeRegistry.buildChatType(MSG_COMMAND_INCOMING));
        MSG_COMMAND_OUTGOING = ResourceKey.m_135785_((ResourceKey)Registries.f_256873_, (ResourceLocation)new ResourceLocation("discord_chat_mod", MSG_COMMAND_OUTGOING_PATH));
        Registry.m_194579_(registry, MSG_COMMAND_OUTGOING, (Object)CustomChatTypeRegistry.buildChatType(MSG_COMMAND_OUTGOING));
        TEAM_MSG_COMMAND_INCOMING = ResourceKey.m_135785_((ResourceKey)Registries.f_256873_, (ResourceLocation)new ResourceLocation("discord_chat_mod", TEAM_MSG_COMMAND_INCOMING_PATH));
        Registry.m_194579_(registry, TEAM_MSG_COMMAND_INCOMING, (Object)CustomChatTypeRegistry.buildChatType(TEAM_MSG_COMMAND_INCOMING));
        TEAM_MSG_COMMAND_OUTGOING = ResourceKey.m_135785_((ResourceKey)Registries.f_256873_, (ResourceLocation)new ResourceLocation("discord_chat_mod", TEAM_MSG_COMMAND_OUTGOING_PATH));
        Registry.m_194579_(registry, TEAM_MSG_COMMAND_OUTGOING, (Object)CustomChatTypeRegistry.buildChatType(TEAM_MSG_COMMAND_OUTGOING));
    }

    public static String[] getParametersByChatType(ResourceKey<ChatType> chatType) {
        String[] stringArray;
        switch (chatType.m_135782_().m_135815_()) {
            case "chat": 
            case "say_command": 
            case "emote_command": {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "{player}";
                stringArray = stringArray2;
                stringArray2[1] = "{message}";
                break;
            }
            case "msg_command_incoming": {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "{sender}";
                stringArray = stringArray3;
                stringArray3[1] = "{message}";
                break;
            }
            case "msg_command_outgoing": {
                String[] stringArray4 = new String[2];
                stringArray4[0] = "{receiver}";
                stringArray = stringArray4;
                stringArray4[1] = "{message}";
                break;
            }
            case "team_msg_command_incoming": 
            case "team_msg_command_outgoing": {
                String[] stringArray5 = new String[3];
                stringArray5[0] = "{team}";
                stringArray5[1] = "{player}";
                stringArray = stringArray5;
                stringArray5[2] = "{message}";
                break;
            }
            default: {
                stringArray = new String[]{};
            }
        }
        return stringArray;
    }

    public static ChatType.Bound buildBound(ResourceKey<ChatType> chatType, RegistryAccess registryAccess, Component sender, @Nullable Component originalMessage) {
        return new ChatType.Bound((ChatType)registryAccess.m_175515_(Registries.f_256873_).m_123013_(chatType), sender, originalMessage);
    }

    private static ChatType buildChatType(ResourceKey<ChatType> key) {
        String narrateTranslationKey = key.m_135782_().m_135815_().equals(EMOTE_COMMAND_PATH) ? "chat.type.emote" : "chat.type.text.narrate";
        List<ChatTypeDecoration.Parameter> chatParameters = List.of(ChatTypeDecoration.Parameter.CONTENT);
        List<ChatTypeDecoration.Parameter> narrationParameters = List.of(ChatTypeDecoration.Parameter.SENDER, ChatTypeDecoration.Parameter.TARGET);
        return new ChatType(new ChatTypeDecoration("%s", chatParameters, Style.f_131099_), new ChatTypeDecoration(narrateTranslationKey, narrationParameters, Style.f_131099_));
    }
}

