/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.chat_style;

import com.denisnumb.discord_chat_mod.DeathMessageUtils;
import com.denisnumb.discord_chat_mod.chat_style.ChatStyleUtils;
import com.denisnumb.discord_chat_mod.chat_style.CustomChatTypeRegistry;
import com.denisnumb.discord_chat_mod.config.ConfigProvider;
import com.denisnumb.discord_chat_mod.config.IConfigProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class MinecraftChatStyleProvider {
    private static Component applyStyleToAdvancement(String translatedTitle, String translatedDescription, Style advancementStyle) {
        MutableComponent title = Component.m_237113_((String)translatedTitle);
        MutableComponent description = ComponentUtils.m_130750_((MutableComponent)title.m_6881_(), (Style)Style.f_131099_.m_131148_(advancementStyle.m_131135_())).m_130946_("\n").m_7220_((Component)Component.m_237113_((String)translatedDescription));
        MutableComponent result = title.m_6881_().m_130938_(arg_0 -> MinecraftChatStyleProvider.lambda$applyStyleToAdvancement$0((Component)description, arg_0));
        return ComponentUtils.m_130748_((Component)result).m_130948_(advancementStyle);
    }

    public static Optional<Component> getStyledAdvancementMessage(Player player, Advancement advancement, String title, String description) {
        String messageStringTemplate;
        IConfigProvider config = ConfigProvider.getConfig();
        DisplayInfo displayInfo = advancement.m_138320_();
        String string = displayInfo.m_14992_() == FrameType.TASK ? config.minecraftPlayerAdvancementTaskStyle() : (messageStringTemplate = displayInfo.m_14992_() == FrameType.GOAL ? config.minecraftPlayerAdvancementGoalStyle() : config.minecraftPlayerAdvancementChallengeStyle());
        String translationKey = displayInfo.m_14992_() == FrameType.TASK ? "chat.type.advancement.task" : (displayInfo.m_14992_() == FrameType.GOAL ? "chat.type.advancement.goal" : "chat.type.advancement.challenge");
        MutableComponent template = ChatStyleUtils.parseConfigTemplateMarkdown(ChatStyleUtils.setConfigTemplateTranslatableParameters(messageStringTemplate, translationKey));
        Style advancementStyle = ChatStyleUtils.parseTemplateParameterStyles(template, "{advancement}").get("{advancement}");
        return Optional.of(ChatStyleUtils.applyParametersToTemplate(template, Map.of("{player}", player.m_5446_(), "{advancement}", MinecraftChatStyleProvider.applyStyleToAdvancement(title, description, advancementStyle))));
    }

    public static Optional<Component> getStyledJoinedLeftMessage(Player player, boolean isJoin) {
        IConfigProvider config = ConfigProvider.getConfig();
        String messageStringTemplate = isJoin ? config.minecraftPlayerJoinedStyle() : config.minecraftPlayerLeftStyle();
        String translationKey = isJoin ? "multiplayer.player.joined" : "multiplayer.player.left";
        return Optional.of(ChatStyleUtils.applyParametersToTemplate(ChatStyleUtils.parseConfigTemplateMarkdown(ChatStyleUtils.setConfigTemplateTranslatableParameters(messageStringTemplate, translationKey)), Map.of("{player}", player.m_5446_())));
    }

    public static Optional<Component> getStyledChatMessage(ResourceKey<ChatType> chatType, ChatMessageComponents components) {
        Component[] componentArray;
        String configTemplate = ChatStyleUtils.getConfigTemplateByChatType(chatType);
        if (configTemplate == null) {
            return Optional.empty();
        }
        String[] params = CustomChatTypeRegistry.getParametersByChatType(chatType);
        if (params.length == 3) {
            Component[] componentArray2 = new Component[3];
            componentArray2[0] = components.team;
            componentArray2[1] = components.player;
            componentArray = componentArray2;
            componentArray2[2] = components.content;
        } else {
            Component[] componentArray3 = new Component[2];
            componentArray3[0] = components.player;
            componentArray = componentArray3;
            componentArray3[1] = components.content;
        }
        Component[] values2 = componentArray;
        Map<String, Component> parameterToComponent = IntStream.range(0, params.length).boxed().collect(Collectors.toMap(i -> params[i], i -> values2[i]));
        return Optional.of(ChatStyleUtils.applyParametersToTemplate(ChatStyleUtils.parseConfigTemplateMarkdown(configTemplate), parameterToComponent));
    }

    public static Optional<Component> getStyledDeathMessage(DeathMessageUtils.DeathMessageComponents components) {
        IConfigProvider config = ConfigProvider.getConfig();
        String causeStyle = config.minecraftPlayerDeathCauseStyle().replace("{death_cause}", "{death.cause}");
        String nameStyle = config.minecraftPlayerDeathNameStyle().replace("{player}", "{died.entity}");
        String entityStyle = config.minecraftPlayerDeathSecondEntityNameStyle().replace("{second_entity}", "{second.entity}");
        String itemStyle = config.minecraftPlayerDeathWeaponStyle().replace("{item}", "{item}");
        MutableComponent causeTemplate = ChatStyleUtils.parseConfigTemplateMarkdown(causeStyle);
        MutableComponent playerTemplate = ChatStyleUtils.parseConfigTemplateMarkdown(nameStyle);
        MutableComponent entityTemplate = ChatStyleUtils.parseConfigTemplateMarkdown(entityStyle);
        MutableComponent itemTemplate = ChatStyleUtils.parseConfigTemplateMarkdown(itemStyle);
        playerTemplate = ChatStyleUtils.applyParametersToTemplate(playerTemplate.m_6881_(), Map.of("{died.entity}", components.diedEntityName()));
        causeTemplate = ChatStyleUtils.applyParametersToTemplate(causeTemplate.m_6881_(), Map.of("{death.cause}", components.deathCause()));
        if (components.killerEntity() != null) {
            entityTemplate = ChatStyleUtils.applyParametersToTemplate(entityTemplate.m_6881_(), Map.of("{second.entity}", components.killerEntity()));
        }
        if (components.item() != null) {
            itemTemplate = ChatStyleUtils.applyParametersToTemplate(itemTemplate.m_6881_(), Map.of("{item}", components.item()));
        }
        HashMap<String, Component> parameterToDeathMessageComponent = new HashMap<String, Component>();
        parameterToDeathMessageComponent.put("{died.entity}", (Component)playerTemplate);
        parameterToDeathMessageComponent.put("{second.entity}", (Component)(components.killerEntity() != null ? entityTemplate : null));
        parameterToDeathMessageComponent.put("{item}", (Component)(components.item() != null ? itemTemplate : null));
        return Optional.of(ChatStyleUtils.applyParametersToTemplate(causeTemplate.m_6881_(), parameterToDeathMessageComponent));
    }

    private static /* synthetic */ Style lambda$applyStyleToAdvancement$0(Component description, Style style) {
        return style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)description));
    }

    public record ChatMessageComponents(Component player, Component content, @Nullable Component team) {
    }
}

