/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.commands;

import com.denisnumb.discord_chat_mod.LocaleProvider;
import com.denisnumb.discord_chat_mod.MinecraftUtils;
import com.denisnumb.discord_chat_mod.chat_style.ChatStyleUtils;
import com.denisnumb.discord_chat_mod.discord.DiscordChannelRegistry;
import com.denisnumb.discord_chat_mod.discord.DiscordUtils;
import com.denisnumb.discord_chat_mod.discord.StickersProvider;
import com.denisnumb.discord_chat_mod.discord.chat_style.DiscordChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.chat_style.MessageType;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class SendStickerCommand {
    private static final SuggestionProvider<CommandSourceStack> STICKERS_PROVIDER = (context, builder) -> {
        String partial = builder.getRemaining().toLowerCase();
        StickersProvider.getNameToStickerDataMap().keySet().stream().filter(stickerName -> stickerName.toLowerCase().contains(partial)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"send_sticker").then(Commands.m_82129_((String)"sticker", (ArgumentType)StringArgumentType.greedyString()).suggests(STICKERS_PROVIDER).executes(context -> {
            String stickerName = StringArgumentType.getString((CommandContext)context, (String)"sticker");
            StickersProvider.StickerData stickerData = StickersProvider.getNameToStickerDataMap().get(stickerName);
            if (stickerData == null) {
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)String.format(LocaleProvider.getTranslate("discord_chat_mod.command.send_sticker.unknown"), stickerName))).create();
            }
            Entity patt0$temp = ((CommandSourceStack)context.getSource()).m_81373_();
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                String stickerMessageContent = String.format(LocaleProvider.getTranslate("discord_chat_mod.sticker"), stickerData.originalName());
                MutableComponent messageWithStickerComponent = Component.m_237113_((String)stickerMessageContent).m_130938_(style -> style.m_131155_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, stickerData.imageUrl())));
                MinecraftUtils.sendMessageToAllPlayersFromPlayer(Map.of("{player}", player.m_5446_(), "{message}", messageWithStickerComponent));
                DiscordUtils.handleDiscord(() -> {
                    Optional<DiscordChatStyleProvider.DiscordMessageComponents> chatComponentsOpt = DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.CHAT, ChatStyleUtils.mergeMaps(Map.of("{message}", stickerMessageContent), DiscordChatStyleProvider.buildPlayerParameters((Entity)player)));
                    DiscordChatStyleProvider.DiscordMessageComponents webhookComponents = new DiscordChatStyleProvider.DiscordMessageComponents(Optional.of(stickerData.imageUrl()), Optional.empty());
                    chatComponentsOpt.ifPresent(discordMessageComponents -> DiscordUtils.sendMessageFromPlayer(ChannelCategory.PLAYER_CHAT, DiscordChannelRegistry.getAllContexts(), player, webhookComponents, discordMessageComponents, stickerData));
                });
            }
            return 1;
        })));
    }
}

