/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.commands.set_avatar;

import com.denisnumb.discord_chat_mod.LocaleProvider;
import com.denisnumb.discord_chat_mod.chat_images.utils.ImageUtils;
import com.denisnumb.discord_chat_mod.commands.set_avatar.AvatarUrlStorage;
import com.denisnumb.discord_chat_mod.markdown.MarkdownParser;
import com.denisnumb.discord_chat_mod.markdown.MarkdownToComponentConverter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;

public class SetAvatarCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"set_avatar_url").then(Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String url = StringArgumentType.getString((CommandContext)context, (String)"url");
            if (!ImageUtils.isImageUrl(ImageUtils.getMimeType(url))) {
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)LocaleProvider.getTranslate("discord_chat_mod.command.set_avatar_url.invalid_url"))).create();
            }
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player == null) {
                return 0;
            }
            AvatarUrlStorage.setUrl(player.m_20148_(), url, ((CommandSourceStack)context.getSource()).m_81377_());
            player.m_213846_((Component)new MarkdownToComponentConverter(MarkdownParser.parseMarkdown(String.format(LocaleProvider.getTranslate("discord_chat_mod.command.set_avatar_url.success"), url))).convertMarkdownTokensToComponent());
            return 1;
        })));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"remove_avatar_url").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
            if (player == null) {
                return 0;
            }
            AvatarUrlStorage.removeUrl(player.m_20148_(), ((CommandSourceStack)context.getSource()).m_81377_());
            player.m_213846_((Component)Component.m_237113_((String)LocaleProvider.getTranslate("discord_chat_mod.command.remove_avatar_url.success")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)));
            return 1;
        }));
    }
}

