/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.commands.vanilla;

import com.denisnumb.discord_chat_mod.MinecraftEvents;
import com.denisnumb.discord_chat_mod.MinecraftUtils;
import com.denisnumb.discord_chat_mod.chat_style.CustomChatTypeRegistry;
import com.denisnumb.discord_chat_mod.chat_style.MinecraftChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;

public class MsgCommand {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        LiteralCommandNode literalCommandNode = commandDispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"msg").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"message", (ArgumentType)MessageArgument.m_96832_()).executes(commandContext -> {
            Collection collection = EntityArgument.m_91477_((CommandContext)commandContext, (String)"targets");
            if (!collection.isEmpty()) {
                MessageArgument.m_245478_((CommandContext)commandContext, (String)"message", playerChatMessage -> MsgCommand.sendMessage((CommandSourceStack)commandContext.getSource(), collection, playerChatMessage));
            }
            return collection.size();
        }))));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"tell").redirect((CommandNode)literalCommandNode));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"w").redirect((CommandNode)literalCommandNode));
    }

    private static void sendMessage(CommandSourceStack commandSourceStack, Collection<ServerPlayer> collection, PlayerChatMessage playerChatMessage) {
        MinecraftUtils.ProcessChatMessageResult chatMessage = MinecraftUtils.processChatMessage(playerChatMessage.m_245692_().getString(), ChannelCategory.PLAYER_CHAT);
        PlayerChatMessage playerChatMessageStyled = playerChatMessage.m_241956_(chatMessage.forMinecraft());
        MinecraftEvents.handleChatMessage(CustomChatTypeRegistry.MSG_COMMAND_INCOMING, new MinecraftChatStyleProvider.ChatMessageComponents(commandSourceStack.m_81357_(), playerChatMessageStyled.m_245692_(), null)).ifPresentOrElse(styledContent -> MsgCommand.sendMessageStyled(commandSourceStack, collection, playerChatMessageStyled, styledContent), () -> MsgCommand.sendMessageDefault(commandSourceStack, collection, playerChatMessageStyled));
    }

    private static void sendMessageStyled(CommandSourceStack commandSourceStack, Collection<ServerPlayer> collection, PlayerChatMessage playerChatMessage, Component styledIncomingContent) {
        ChatType.Bound styledIncoming = CustomChatTypeRegistry.buildBound(CustomChatTypeRegistry.MSG_COMMAND_INCOMING, commandSourceStack.m_5894_(), commandSourceStack.m_81357_(), playerChatMessage.m_245692_());
        OutgoingChatMessage incomingChatMessage = OutgoingChatMessage.m_247282_((PlayerChatMessage)playerChatMessage.m_241956_(styledIncomingContent));
        boolean bl = false;
        for (ServerPlayer serverPlayer : collection) {
            Optional<Component> styledOutgoingContentOptional = MinecraftEvents.handleChatMessage(CustomChatTypeRegistry.MSG_COMMAND_OUTGOING, new MinecraftChatStyleProvider.ChatMessageComponents(serverPlayer.m_5446_(), playerChatMessage.m_245692_(), null));
            if (!styledOutgoingContentOptional.isPresent()) continue;
            ChatType.Bound styledOutgoing = CustomChatTypeRegistry.buildBound(CustomChatTypeRegistry.MSG_COMMAND_OUTGOING, commandSourceStack.m_5894_(), serverPlayer.m_5446_(), playerChatMessage.m_245692_());
            OutgoingChatMessage outgoingChatMessage = OutgoingChatMessage.m_247282_((PlayerChatMessage)playerChatMessage.m_241956_(styledOutgoingContentOptional.get()));
            commandSourceStack.m_246719_(outgoingChatMessage, false, styledOutgoing);
            boolean bl2 = commandSourceStack.m_243061_(serverPlayer);
            serverPlayer.m_245069_(incomingChatMessage, bl2, styledIncoming);
            bl |= bl2 && playerChatMessage.m_243059_();
        }
        if (bl) {
            commandSourceStack.m_243053_(PlayerList.f_243017_);
        }
    }

    private static void sendMessageDefault(CommandSourceStack commandSourceStack, Collection<ServerPlayer> collection, PlayerChatMessage playerChatMessage) {
        ChatType.Bound bound = ChatType.m_241073_((ResourceKey)ChatType.f_240674_, (CommandSourceStack)commandSourceStack);
        OutgoingChatMessage outgoingChatMessage = OutgoingChatMessage.m_247282_((PlayerChatMessage)playerChatMessage);
        boolean bl = false;
        for (ServerPlayer serverPlayer : collection) {
            ChatType.Bound bound2 = ChatType.m_241073_((ResourceKey)ChatType.f_240668_, (CommandSourceStack)commandSourceStack).m_241018_(serverPlayer.m_5446_());
            commandSourceStack.m_246719_(outgoingChatMessage, false, bound2);
            boolean bl2 = commandSourceStack.m_243061_(serverPlayer);
            serverPlayer.m_245069_(outgoingChatMessage, bl2, bound);
            bl |= bl2 && playerChatMessage.m_243059_();
        }
        if (bl) {
            commandSourceStack.m_243053_(PlayerList.f_243017_);
        }
    }
}

