/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.commands.vanilla;

import com.denisnumb.discord_chat_mod.MinecraftEvents;
import com.denisnumb.discord_chat_mod.MinecraftUtils;
import com.denisnumb.discord_chat_mod.chat_style.CustomChatTypeRegistry;
import com.denisnumb.discord_chat_mod.chat_style.MinecraftChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.PlayerTeam;

public class TeamMsgCommand {
    private static final Style SUGGEST_STYLE = Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.type.team.hover"))).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/teammsg "));
    private static final SimpleCommandExceptionType ERROR_NOT_ON_TEAM = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.teammsg.failed.noteam"));

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        LiteralCommandNode literalCommandNode = commandDispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"teammsg").then(Commands.m_82129_((String)"message", (ArgumentType)MessageArgument.m_96832_()).executes(commandContext -> {
            CommandSourceStack commandSourceStack = (CommandSourceStack)commandContext.getSource();
            Entity entity = commandSourceStack.m_81374_();
            PlayerTeam playerTeam = (PlayerTeam)entity.m_5647_();
            if (playerTeam == null) {
                throw ERROR_NOT_ON_TEAM.create();
            }
            List<ServerPlayer> list = commandSourceStack.m_81377_().m_6846_().m_11314_().stream().filter(serverPlayer -> serverPlayer == entity || serverPlayer.m_5647_() == playerTeam).toList();
            if (!list.isEmpty()) {
                MessageArgument.m_245478_((CommandContext)commandContext, (String)"message", playerChatMessage -> TeamMsgCommand.sendMessage(commandSourceStack, entity, playerTeam, list, playerChatMessage));
            }
            return list.size();
        })));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"tm").redirect((CommandNode)literalCommandNode));
    }

    private static void sendMessage(CommandSourceStack commandSourceStack, Entity entity, PlayerTeam playerTeam, List<ServerPlayer> list, PlayerChatMessage playerChatMessage) {
        MinecraftUtils.ProcessChatMessageResult chatMessage = MinecraftUtils.processChatMessage(playerChatMessage.m_245692_().getString(), ChannelCategory.PLAYER_CHAT);
        PlayerChatMessage playerChatMessageStyled = playerChatMessage.m_241956_(chatMessage.forMinecraft());
        MinecraftEvents.handleChatMessage(CustomChatTypeRegistry.TEAM_MSG_COMMAND_INCOMING, new MinecraftChatStyleProvider.ChatMessageComponents(commandSourceStack.m_81357_(), playerChatMessageStyled.m_245692_(), (Component)playerTeam.m_83367_().m_130948_(SUGGEST_STYLE))).ifPresentOrElse(styledContent -> TeamMsgCommand.sendMessageStyled(commandSourceStack, entity, playerTeam, list, playerChatMessageStyled, styledContent), () -> TeamMsgCommand.sendMessageDefault(commandSourceStack, entity, playerTeam, list, playerChatMessageStyled));
    }

    private static void sendMessageStyled(CommandSourceStack commandSourceStack, Entity entity, PlayerTeam playerTeam, List<ServerPlayer> list, PlayerChatMessage playerChatMessage, Component styledIncomingContent) {
        Optional<Component> styledOutgoungContentOptional = MinecraftEvents.handleChatMessage(CustomChatTypeRegistry.TEAM_MSG_COMMAND_OUTGOING, new MinecraftChatStyleProvider.ChatMessageComponents(commandSourceStack.m_81357_(), playerChatMessage.m_245692_(), (Component)playerTeam.m_83367_().m_130948_(SUGGEST_STYLE)));
        if (styledOutgoungContentOptional.isPresent()) {
            ChatType.Bound styledIncoming = CustomChatTypeRegistry.buildBound(CustomChatTypeRegistry.TEAM_MSG_COMMAND_INCOMING, commandSourceStack.m_5894_(), commandSourceStack.m_81357_(), playerChatMessage.m_245692_());
            ChatType.Bound styledOutgoing = CustomChatTypeRegistry.buildBound(CustomChatTypeRegistry.TEAM_MSG_COMMAND_OUTGOING, commandSourceStack.m_5894_(), commandSourceStack.m_81357_(), playerChatMessage.m_245692_());
            OutgoingChatMessage incomingChatMessage = OutgoingChatMessage.m_247282_((PlayerChatMessage)playerChatMessage.m_241956_(styledIncomingContent));
            OutgoingChatMessage outgoingChatMessage = OutgoingChatMessage.m_247282_((PlayerChatMessage)playerChatMessage.m_241956_(styledOutgoungContentOptional.get()));
            boolean bl = false;
            for (ServerPlayer serverPlayer : list) {
                ChatType.Bound bound = serverPlayer == entity ? styledOutgoing : styledIncoming;
                OutgoingChatMessage message = serverPlayer == entity ? outgoingChatMessage : incomingChatMessage;
                boolean bl2 = commandSourceStack.m_243061_(serverPlayer);
                serverPlayer.m_245069_(message, bl2, bound);
                bl |= bl2 && playerChatMessage.m_243059_();
            }
            if (bl) {
                commandSourceStack.m_243053_(PlayerList.f_243017_);
            }
        }
    }

    private static void sendMessageDefault(CommandSourceStack commandSourceStack, Entity entity, PlayerTeam playerTeam, List<ServerPlayer> list, PlayerChatMessage playerChatMessage) {
        MutableComponent component = playerTeam.m_83367_().m_130948_(SUGGEST_STYLE);
        ChatType.Bound bound = ChatType.m_241073_((ResourceKey)ChatType.f_241694_, (CommandSourceStack)commandSourceStack).m_241018_((Component)component);
        ChatType.Bound bound2 = ChatType.m_241073_((ResourceKey)ChatType.f_241626_, (CommandSourceStack)commandSourceStack).m_241018_((Component)component);
        OutgoingChatMessage outgoingChatMessage = OutgoingChatMessage.m_247282_((PlayerChatMessage)playerChatMessage);
        boolean bl = false;
        for (ServerPlayer serverPlayer : list) {
            ChatType.Bound bound3 = serverPlayer == entity ? bound2 : bound;
            boolean bl2 = commandSourceStack.m_243061_(serverPlayer);
            serverPlayer.m_245069_(outgoingChatMessage, bl2, bound3);
            bl |= bl2 && playerChatMessage.m_243059_();
        }
        if (bl) {
            commandSourceStack.m_243053_(PlayerList.f_243017_);
        }
    }
}

