/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.commands.vanilla;

import com.denisnumb.discord_chat_mod.MinecraftUtils;
import com.denisnumb.discord_chat_mod.discord.DiscordChannelRegistry;
import com.denisnumb.discord_chat_mod.discord.DiscordUtils;
import com.denisnumb.discord_chat_mod.discord.chat_style.DiscordChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.chat_style.MessageType;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class TellrawCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tellraw").requires(source2 -> source2.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"message", (ArgumentType)ComponentArgument.m_87114_()).executes(ctx -> {
            Collection players = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            Component message = ComponentArgument.m_87117_((CommandContext)ctx, (String)"message");
            if (ctx.getInput().split(" ", 3)[1].equals("@a")) {
                DiscordUtils.handleDiscord(() -> {
                    StringBuilder messageTextBuilder = new StringBuilder();
                    messageTextBuilder.append(TellrawCommand.parseComponentContents(message.m_214077_(), message.m_7383_()));
                    for (Component comp : message.m_7360_()) {
                        messageTextBuilder.append(TellrawCommand.parseComponentContents(comp.m_214077_(), comp.m_7383_()));
                    }
                    DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.TELLRAW_COMMAND, Map.of("{message}", DiscordUtils.replaceEmojiCodesToDiscordMentions(messageTextBuilder.toString()))).ifPresent(components -> DiscordUtils.sendMessageFromServer(ChannelCategory.TELLRAW_COMMAND, DiscordChannelRegistry.getAllContexts(), components));
                });
            }
            for (ServerPlayer player : players) {
                player.m_240418_((Component)ComponentUtils.m_130731_((CommandSourceStack)((CommandSourceStack)ctx.getSource()), (Component)message, (Entity)player, (int)0), false);
            }
            return players.size();
        }))));
    }

    private static String parseComponentContents(ComponentContents componentContents, Style style) {
        try {
            MutableComponent component = componentContents.m_213698_(null, null, 0);
            if (componentContents instanceof SelectorContents) {
                SelectorContents selectorContents = (SelectorContents)componentContents;
                List<ServerPlayer> playerList = MinecraftUtils.getPlayerListBySelector(selectorContents.m_237466_());
                String result = component.getString();
                if (!playerList.isEmpty()) {
                    result = String.join((CharSequence)", ", playerList.stream().map(p -> p.m_5446_().getString()).toList());
                }
                return TellrawCommand.applyStyles(style, result);
            }
            return TellrawCommand.applyStyles(style, component.getString());
        }
        catch (CommandSyntaxException e) {
            return "";
        }
    }

    private static String applyStyles(Style style, String translatedText) {
        if (style.m_131154_()) {
            translatedText = "**" + (String)translatedText + "**";
        }
        if (style.m_131161_()) {
            translatedText = "*" + (String)translatedText + "*";
        }
        if (style.m_131168_()) {
            translatedText = "~~" + (String)translatedText + "~~";
        }
        if (style.m_131171_()) {
            translatedText = "__" + (String)translatedText + "__";
        }
        if (style.m_131176_()) {
            translatedText = "||" + (String)translatedText + "||";
        }
        return translatedText;
    }
}

