/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.config.configs;

import com.shadow.com.electronwill.nightconfig.core.CommentedConfig;

public class CommonConfig {
    public static String discordBotToken;
    public static String serverLogsChannelId;
    public static String serverLogsToDiscordLoggingLevel;
    public static boolean logDiscordMessages;
    public static boolean logDiscordErrorsToServerChat;
    public static String discordErrorsChatPlayerSelector;
    public static String modLocale;
    public static int utcOffsetHours;

    public static void loadCommonConfig(CommentedConfig commonConfig) {
        discordBotToken = commonConfig.getOrElse("discordBotToken", "");
        commonConfig.set("discordBotToken", (Object)discordBotToken);
        commonConfig.setComment("discordBotToken", " Read more about configuration here: https://github.com/denisnumb/discord-chat-mod/wiki\n \n Bot access token\n [!] Make sure all Privileged Gateway Intents are enabled on https://discord.com/developers/applications/<your_app_id>/bot\n [!] Make sure the bot has the following permissions on the server:\n [!] - VIEW_CHANNEL\n [!] - MESSAGE_SEND\n [!] - MESSAGE_SEND_IN_THREADS\n [!] - MESSAGE_EMBED_LINKS\n [!] - MESSAGE_ATTACH_FILES\n [!] - PIN_MESSAGES\n [!] - MESSAGE_HISTORY");
        serverLogsChannelId = commonConfig.getOrElse("serverLogsChannelId", "");
        commonConfig.set("serverLogsChannelId", (Object)serverLogsChannelId);
        commonConfig.setComment("serverLogsChannelId", " Discord channel ID for logs from Minecraft Server console\n Leave blank if you don't want to send server logs to Discord.");
        serverLogsToDiscordLoggingLevel = commonConfig.getOrElse("serverLogsToDiscordLoggingLevel", "INFO");
        if (!serverLogsToDiscordLoggingLevel.matches("(?i)^(INFO|WARN|ERROR)$")) {
            serverLogsToDiscordLoggingLevel = "INFO";
        }
        commonConfig.set("serverLogsToDiscordLoggingLevel", (Object)serverLogsToDiscordLoggingLevel);
        commonConfig.setComment("serverLogsToDiscordLoggingLevel", " The minimum level of logs that will be sent to Discord.\n Possible values: ERROR, WARN, INFO");
        logDiscordMessages = commonConfig.getOrElse("logDiscordMessages", Boolean.valueOf(true));
        commonConfig.set("logDiscordMessages", (Object)logDiscordMessages);
        commonConfig.setComment("logDiscordMessages", " Do logging to the server console messages from discord");
        logDiscordErrorsToServerChat = commonConfig.getOrElse("logDiscordErrorsToServerChat", Boolean.valueOf(true));
        commonConfig.set("logDiscordErrorsToServerChat", (Object)logDiscordErrorsToServerChat);
        commonConfig.setComment("logDiscordErrorsToServerChat", " Notify about internal Discord interaction errors in the server's in-game chat");
        discordErrorsChatPlayerSelector = commonConfig.getOrElse("discordErrorsChatPlayerSelector", "@a");
        commonConfig.set("discordErrorsChatPlayerSelector", (Object)discordErrorsChatPlayerSelector);
        commonConfig.setComment("discordErrorsChatPlayerSelector", " If logDiscordErrorsToServerChat=true, then the errors in the chat will be seen by players with the specified selector\n By default, \"@a\" \u2014 all players. You can specify a specific nickname or attribute, for example, \"@a[tag=admin]\"");
        modLocale = commonConfig.getOrElse("modLocale", "en_us");
        commonConfig.set("modLocale", (Object)modLocale);
        commonConfig.setComment("modLocale", " Mod locale");
        utcOffsetHours = commonConfig.getOrElse("utcOffsetHours", Integer.valueOf(0));
        if (utcOffsetHours < -12) {
            utcOffsetHours = -12;
        }
        if (utcOffsetHours > 14) {
            utcOffsetHours = 14;
        }
        commonConfig.set("utcOffsetHours", (Object)utcOffsetHours);
        commonConfig.setComment("utcOffsetHours", " The offset of the current time from UTC in hours.\n Used to generate timestamps for message style configurations." + String.format("\n Default: %d\n Range: -12 ~ 14", 0));
    }
}

