/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.discord;

import com.denisnumb.discord_chat_mod.DiscordChatMod;
import com.denisnumb.discord_chat_mod.LocaleProvider;
import com.denisnumb.discord_chat_mod.MinecraftUtils;
import com.denisnumb.discord_chat_mod.chat_style.Parameters;
import com.denisnumb.discord_chat_mod.config.ConfigProvider;
import com.denisnumb.discord_chat_mod.config.IConfigProvider;
import com.denisnumb.discord_chat_mod.discord.DiscordChannelRegistry;
import com.denisnumb.discord_chat_mod.discord.DiscordUtils;
import com.denisnumb.discord_chat_mod.discord.chat_style.DiscordChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.chat_style.MessageType;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.denisnumb.discord_chat_mod.discord.model.DiscordGuildContext;
import com.mojang.logging.LogUtils;
import com.shadow.net.dv8tion.jda.api.entities.Activity;
import com.shadow.net.dv8tion.jda.api.entities.Message;
import com.shadow.net.dv8tion.jda.api.entities.channel.middleman.GuildMessageChannel;
import com.shadow.net.dv8tion.jda.api.requests.restaction.pagination.PinnedMessagePaginationAction;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ServerStatusController {
    private static List<@Nullable Message> serverStatusMessages;
    @Nullable
    private static ScheduledExecutorService scheduler;
    private static long lastInvocationTime;
    private static final Logger LOGGER;

    public static void updateServerStatusWithDelay() {
        if (!DiscordChatMod.isDiscordConnected() || scheduler == null) {
            return;
        }
        lastInvocationTime = System.currentTimeMillis();
        scheduler.schedule(() -> {
            if (System.currentTimeMillis() - lastInvocationTime >= 10000L) {
                ServerStatusController.updateServerStatus();
            }
        }, 10L, TimeUnit.SECONDS);
    }

    public static void initServerStatusController() {
        scheduler = Executors.newSingleThreadScheduledExecutor();
        Map<DiscordGuildContext, Optional<Message>> existingStatusMessages = ServerStatusController.findPinnedStatusMessages();
        serverStatusMessages = existingStatusMessages.entrySet().stream().map(entry -> ((Optional)entry.getValue()).orElseGet(() -> ServerStatusController.sendPinnedStatusMessage((DiscordGuildContext)entry.getKey(), ServerStatusController.createServerStatusMessageComponents()).orElse(null))).toList();
        for (Message statusMessage : serverStatusMessages) {
            if (statusMessage == null || statusMessage.isPinned()) continue;
            try {
                statusMessage.pin().queue();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
        ServerStatusController.updateServerStatusWithDelay();
    }

    public static void updateServerStatusMessageToUnavailable() {
        if (scheduler != null) {
            scheduler.shutdownNow();
        }
        if (DiscordChatMod.isDiscordConnected()) {
            serverStatusMessages.forEach(statusMessage -> {
                if (statusMessage != null) {
                    DiscordUtils.editMessage(statusMessage, DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.PINNED_STATUS_UNAVAILABLE, Map.of()).orElseThrow());
                }
            });
        }
    }

    private static DiscordChatStyleProvider.DiscordMessageComponents createServerStatusMessageComponents() {
        return MinecraftUtils.getServerPlayerCount(DiscordChatMod.server) == 0 ? DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.PINNED_STATUS_AVAILABLE, Map.of()).orElseThrow() : DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.PINNED_STATUS_PLAYERS, Map.of(Parameters.ONLINE_PLAYERS, ServerStatusController.getOnlineCountString(), "{player_list}", ServerStatusController.buildPlayerList(), "{player_count}", String.valueOf(MinecraftUtils.getServerPlayerCount(DiscordChatMod.server)), "{max_players}", String.valueOf(MinecraftUtils.getServerMaxPlayers(DiscordChatMod.server)))).orElseThrow();
    }

    private static String buildPlayerList() {
        IConfigProvider config = ConfigProvider.getConfig();
        int maxNicknames = 50;
        String[] players = MinecraftUtils.getServerPlayerNames(DiscordChatMod.server);
        String delimiter = config.discordPinnedStatusMessagePlayerListDelimiter();
        String nicknameStyle = config.discordPinnedStatusMessagePlayerListNicknameStyle();
        Object result = IntStream.range(0, Math.min(maxNicknames, players.length)).mapToObj(i -> nicknameStyle.replace("{player}", players[i]).replace("{counter}", String.valueOf(i + 1))).collect(Collectors.joining(delimiter));
        if (players.length > 2 || players.length == 0) {
            result = (String)result + delimiter + ". . .";
        }
        return result;
    }

    private static void updateServerStatus() {
        if (DiscordChatMod.isDiscordConnected()) {
            serverStatusMessages.forEach(statusMessage -> {
                if (statusMessage != null) {
                    DiscordUtils.editMessage(statusMessage, ServerStatusController.createServerStatusMessageComponents());
                }
            });
        }
        DiscordChatMod.jda.getPresence().setActivity(Activity.customStatus(ServerStatusController.getOnlineCountString()));
    }

    private static String getOnlineCountString() {
        return String.format(LocaleProvider.getTranslate("discord_chat_mod.server.status.online_players"), MinecraftUtils.getServerPlayerCount(DiscordChatMod.server), MinecraftUtils.getServerMaxPlayers(DiscordChatMod.server));
    }

    public static Optional<Message> sendPinnedStatusMessage(DiscordGuildContext guildContext, DiscordChatStyleProvider.DiscordMessageComponents messageComponents) {
        if (!guildContext.enablePinnedStatusMessage) {
            return Optional.empty();
        }
        GuildMessageChannel channel = guildContext.getChannel(ChannelCategory.PINNED_STATUS);
        return DiscordUtils.prepareDiscordMessage(channel, messageComponents).flatMap(mca -> DiscordUtils.sendDiscordMessage(mca, channel, true));
    }

    private static Map<DiscordGuildContext, Optional<Message>> findPinnedStatusMessages() {
        try {
            return DiscordChannelRegistry.getAllContexts().stream().map(ctx -> {
                Optional<Message> statusMessage = ((List)ctx.getChannel(ChannelCategory.PINNED_STATUS).retrievePinnedMessages().complete()).stream().map(PinnedMessagePaginationAction.PinnedMessage::getMessage).filter(message -> message.getAuthor().getId().equals(DiscordChatMod.jda.getSelfUser().getId())).findFirst();
                return Map.entry(ctx, statusMessage);
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return Map.of();
        }
    }

    static {
        lastInvocationTime = 0L;
        LOGGER = LogUtils.getLogger();
    }
}

