/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.discord;

import com.denisnumb.discord_chat_mod.DiscordChatMod;
import com.denisnumb.discord_chat_mod.chat_images.ImageStorage;
import com.denisnumb.discord_chat_mod.chat_images.model.AbstractImage;
import com.denisnumb.discord_chat_mod.discord.DiscordChannelRegistry;
import com.denisnumb.discord_chat_mod.discord.model.DiscordGuildContext;
import com.shadow.net.dv8tion.jda.api.entities.ISnowflake;
import com.shadow.net.dv8tion.jda.api.entities.sticker.GuildSticker;
import com.shadow.net.dv8tion.jda.api.entities.sticker.Sticker;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class StickersProvider {
    public static Map<String, AbstractImage> CLIENT_STICKER_CACHE = new HashMap<String, AbstractImage>();
    private static long lastGetNameToRawStickerMapGet = 0L;
    private static Map<String, StickerData> cachedNameToRawStickerDataMap;

    public static void dropTimeouts() {
        lastGetNameToRawStickerMapGet = 0L;
    }

    public static Map<String, String> getNameToUrlMap() {
        return StickersProvider.getNameToStickerDataMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StickerData)entry.getValue()).imageUrl));
    }

    public static Map<String, StickerData> getNameToStickerDataMap() {
        if (!DiscordChatMod.isDiscordConnected()) {
            return Map.of();
        }
        if (System.currentTimeMillis() - lastGetNameToRawStickerMapGet < 300000L) {
            return cachedNameToRawStickerDataMap;
        }
        lastGetNameToRawStickerMapGet = System.currentTimeMillis();
        cachedNameToRawStickerDataMap = DiscordChannelRegistry.getAllContexts().stream().map(DiscordGuildContext::getGuild).flatMap(guild -> guild.getStickers().stream()).collect(Collectors.groupingBy(Sticker::getName)).entrySet().stream().flatMap(entry -> {
            String baseName = (String)entry.getKey();
            List<GuildSticker> sortedStickers = ((List)entry.getValue()).stream().sorted(Comparator.comparing(ISnowflake::getTimeCreated)).toList();
            return IntStream.range(0, sortedStickers.size()).mapToObj(i -> {
                GuildSticker sticker = (GuildSticker)sortedStickers.get(i);
                String guildName = sticker.getGuild() == null ? "" : String.format("(%s)", sticker.getGuild().getName());
                String nameWithIndex = i == 0 ? baseName : String.format("%s %d", baseName, i);
                String name = String.format("%s %s", nameWithIndex, guildName);
                return Map.entry(name, new StickerData(sticker.getIconUrl(), sticker.getId(), sticker.getName()));
            });
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return cachedNameToRawStickerDataMap;
    }

    public static void loadClient(Map<String, String> rawStickers) {
        if (!rawStickers.isEmpty()) {
            CLIENT_STICKER_CACHE.clear();
        }
        ExecutorService executor = Executors.newFixedThreadPool(10);
        rawStickers.forEach((name, url) -> {
            if (!CLIENT_STICKER_CACHE.containsKey(name)) {
                executor.submit(() -> {
                    AbstractImage image = ImageStorage.parseEmojiOrSticker(url);
                    if (image != null) {
                        CLIENT_STICKER_CACHE.putIfAbsent((String)name, image);
                    }
                });
            }
        });
        executor.shutdown();
        ScheduledExecutorService monitor = Executors.newSingleThreadScheduledExecutor();
        monitor.execute(() -> {
            try {
                if (!executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
                Thread.currentThread().interrupt();
            }
            finally {
                monitor.shutdown();
            }
        });
    }

    public record StickerData(String imageUrl, String discordId, String originalName) {
    }
}

