/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.discord;

import com.denisnumb.discord_chat_mod.chat_images.utils.ImageUtils;
import com.denisnumb.discord_chat_mod.commands.set_avatar.AvatarUrlStorage;
import com.denisnumb.discord_chat_mod.config.ConfigProvider;
import com.denisnumb.discord_chat_mod.config.IConfigProvider;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.mojang.logging.LogUtils;
import com.shadow.net.dv8tion.jda.api.entities.MessageEmbed;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;

public class WebhookUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new Gson();
    private static ExecutorService EXECUTOR;

    public static void initWebhookSendExecutor() {
        EXECUTOR = Executors.newSingleThreadExecutor();
    }

    public static void stopWebhookSendExecutor() {
        if (EXECUTOR != null) {
            EXECUTOR.shutdownNow();
            EXECUTOR = null;
        }
    }

    public static void sendWebhook(String webhookUrl, Supplier<WebhookPayload> payloadSupplier) {
        if (EXECUTOR != null) {
            EXECUTOR.submit(() -> WebhookUtils.sendDiscordWebhook(webhookUrl, GSON.toJson(payloadSupplier.get())));
        }
    }

    public static Future<Optional<String>> sendWebhookWithImage(String webhookUrl, WebhookPayload payload, WebhookAttachment attachment) {
        return WebhookUtils.sendWebhookWithFiles(webhookUrl, payload, List.of(attachment), true);
    }

    public static void sendWebhookWithFiles(String webhookUrl, WebhookPayload payload, List<WebhookAttachment> images) {
        if (payload.content == null && payload.embeds == null && (images == null || images.isEmpty())) {
            return;
        }
        WebhookUtils.sendWebhookWithFiles(webhookUrl, payload, images, false);
    }

    private static Future<Optional<String>> sendWebhookWithFiles(String webhookUrl, WebhookPayload payload, List<WebhookAttachment> images, boolean returnImageUrl) {
        return EXECUTOR.submit(() -> {
            try {
                String boundary = UUID.randomUUID().toString();
                HttpURLConnection connection = WebhookUtils.getHttpURLConnection(webhookUrl, "multipart/form-data; boundary=" + boundary);
                try (DataOutputStream out = new DataOutputStream(connection.getOutputStream());){
                    WebhookUtils.writePayloadJson(out, boundary, payload);
                    WebhookUtils.writeImageParts(out, boundary, images);
                    WebhookUtils.finishMultipart(out, boundary);
                }
                WebhookUtils.handleResponseCode(connection);
                Optional<Object> imageUrl = returnImageUrl ? WebhookUtils.getSentImageUrl(connection) : Optional.empty();
                connection.disconnect();
                return imageUrl;
            }
            catch (Exception e) {
                LOGGER.error("SendWebhookError: " + e.getMessage(), (Throwable)e);
                return Optional.empty();
            }
        });
    }

    private static void writePayloadJson(DataOutputStream out, String boundary, WebhookPayload payload) throws IOException {
        String payloadJson = GSON.toJson((Object)payload);
        out.writeBytes("--" + boundary + "\r\n");
        out.writeBytes("Content-Disposition: form-data; name=\"payload_json\"\r\n");
        out.writeBytes("Content-Type: application/json\r\n\r\n");
        out.write(payloadJson.getBytes(StandardCharsets.UTF_8));
        out.writeBytes("\r\n");
    }

    private static void writeImageParts(DataOutputStream out, String boundary, List<WebhookAttachment> images) throws IOException {
        int index = 0;
        for (WebhookAttachment image : images) {
            out.writeBytes("--" + boundary + "\r\n");
            out.writeBytes("Content-Disposition: form-data; name=\"file" + index + "\"; filename=\"" + image.fileName + "\"\r\n");
            out.writeBytes("Content-Type: application/octet-stream\r\n\r\n");
            out.write(image.data);
            out.writeBytes("\r\n");
            ++index;
        }
    }

    private static void finishMultipart(DataOutputStream out, String boundary) throws IOException {
        out.writeBytes("--" + boundary + "--\r\n");
        out.flush();
    }

    public static String getWebhookServerName() {
        String configValue = ConfigProvider.getConfig().webhookServerName();
        return configValue.isBlank() ? null : configValue.replaceAll("(?i)discord", "DC");
    }

    public static String getPlayerAvatarUrl(Player player) {
        Optional<String> optionalUUID;
        String customAvatarUrl;
        IConfigProvider config = ConfigProvider.getConfig();
        if (config.isSetAvatarUrlCommandEnabled() && (customAvatarUrl = AvatarUrlStorage.getUrl(player)) != null) {
            return customAvatarUrl;
        }
        String avatarUrlTemplate = config.webhookPlayerAvatarUrl();
        String defaultAvatarUrl = config.webhookPlayerDefaultAvatarUrl();
        String playerName = player.m_7755_().getString();
        if ((avatarUrlTemplate = avatarUrlTemplate.replace("<name>", playerName)).contains("<uuid>") && (optionalUUID = WebhookUtils.getUUIDFromMojangAPI(playerName)).isPresent()) {
            avatarUrlTemplate = avatarUrlTemplate.replace("<uuid>", optionalUUID.get());
        }
        if (ImageUtils.isImageUrl(ImageUtils.getMimeType(avatarUrlTemplate))) {
            return avatarUrlTemplate;
        }
        return ImageUtils.isImageUrl(ImageUtils.getMimeType(defaultAvatarUrl)) ? defaultAvatarUrl : "https://mc-heads.net/avatar/steve_head_png";
    }

    public static Optional<String> getUUIDFromMojangAPI(String username) {
        try {
            String inputLine;
            URL url = new URI("https://api.mojang.com/users/profiles/minecraft/" + username).toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            connection.setRequestMethod("GET");
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            JsonObject json = JsonParser.parseString((String)response.toString()).getAsJsonObject();
            return Optional.of(json.get("id").getAsString());
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    private static void sendDiscordWebhook(String webhookUrl, String jsonPayload) {
        try {
            HttpURLConnection connection = WebhookUtils.getHttpURLConnection(webhookUrl, "application/json");
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonPayload.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            WebhookUtils.handleResponseCode(connection);
            connection.disconnect();
        }
        catch (Exception e) {
            LOGGER.error("SendWebhookError: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> getSentImageUrl(HttpURLConnection connection) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String inputLine;
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            JsonObject responseJson = JsonParser.parseString((String)response.toString()).getAsJsonObject();
            JsonArray attachments = responseJson.getAsJsonArray("attachments");
            JsonArray embeds = responseJson.getAsJsonArray("embeds");
            if (attachments != null && !attachments.isEmpty()) {
                JsonObject attachment = attachments.get(0).getAsJsonObject();
                Optional<String> optional = Optional.of(attachment.get("url").getAsString());
                return optional;
            }
            if (embeds == null) return Optional.empty();
            if (embeds.isEmpty()) return Optional.empty();
            JsonObject embed = embeds.get(0).getAsJsonObject();
            if (!embed.has("image")) return Optional.empty();
            Optional<String> optional = Optional.of(embed.getAsJsonObject("image").get("url").getAsString());
            return optional;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    private static void handleResponseCode(HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        if (responseCode != 204 && responseCode != 200) {
            LOGGER.error("Webhook response code: " + responseCode);
            try (InputStream err = connection.getErrorStream();){
                if (err != null) {
                    String response = new String(err.readAllBytes(), StandardCharsets.UTF_8);
                    LOGGER.error("DiscordWebhookError: " + response);
                }
            }
        }
    }

    private static HttpURLConnection getHttpURLConnection(String webhookUrl, String contentType) throws URISyntaxException, IOException {
        URL url = new URI(webhookUrl).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", contentType);
        connection.setDoOutput(true);
        return connection;
    }

    public static class WebhookPayload {
        String username;
        @SerializedName(value="avatar_url")
        String avatarUrl;
        List<WebhookEmbed> embeds;
        String content;

        public WebhookPayload(String content) {
            this(content, null);
        }

        public WebhookPayload(MessageEmbed embed) {
            this(null, embed);
        }

        public WebhookPayload(String content, MessageEmbed embed) {
            if (content != null) {
                content = content.isEmpty() ? null : content;
            }
            this.content = content;
            if (embed != null) {
                int color = embed.getColorRaw() == 0x1FFFFFFF ? 3881793 : embed.getColorRaw();
                EmbedImage image = embed.getImage() == null ? null : new EmbedImage(embed.getImage().getUrl());
                MessageEmbed.AuthorInfo authorInfo = embed.getAuthor();
                EmbedAuthor author = authorInfo == null ? null : new EmbedAuthor(authorInfo.getName(), authorInfo.getUrl(), authorInfo.getIconUrl());
                EmbedThumbnail thumbnail = embed.getThumbnail() == null ? null : new EmbedThumbnail(embed.getThumbnail().getUrl());
                List<EmbedField> embedFields = embed.getFields().stream().map(f -> new EmbedField(f.getName(), f.getValue(), f.isInline())).toList();
                EmbedFooter footer = embed.getFooter() == null ? null : new EmbedFooter(embed.getFooter().getText(), embed.getFooter().getIconUrl());
                this.embeds = List.of(new WebhookEmbed(embed.getTitle(), embed.getDescription(), embed.getUrl(), color, author, thumbnail, image, embedFields, footer, embed.getTimestamp() == null ? null : embed.getTimestamp().format(DateTimeFormatter.ISO_INSTANT)));
            }
        }

        public WebhookPayload setUsername(String username) {
            this.username = username;
            return this;
        }

        public WebhookPayload setAvatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
            return this;
        }

        private record EmbedImage(String url) {
        }

        private record EmbedAuthor(String name, String url, String icon_url) {
        }

        private record EmbedThumbnail(String url) {
        }

        private record EmbedFooter(String text, String icon_url) {
        }

        private record WebhookEmbed(String title, String description, String url, int color, EmbedAuthor author, EmbedThumbnail thumbnail, EmbedImage image, List<EmbedField> fields, EmbedFooter footer, String timestamp) {
        }

        private record EmbedField(String name, String value, Boolean inline) {
        }
    }

    public record WebhookAttachment(byte[] data, String fileName) {
    }
}

