/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.forge.network;

import com.denisnumb.discord_chat_mod.network.CustomPayloadPackets;
import com.denisnumb.discord_chat_mod.network.PacketHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod.EventBusSubscriber(modid="discord_chat_mod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeNetworking {
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("discord_chat_mod", "main")).serverAcceptedVersions(status -> true).clientAcceptedVersions(status -> true).networkProtocolVersion(() -> "2").simpleChannel();

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            int id = 0;
            CHANNEL.messageBuilder(CustomPayloadPackets.RequestDiscordMentionsPacket.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(CustomPayloadPackets.BaseRequestPacket::encode).decoder(CustomPayloadPackets.RequestDiscordMentionsPacket::new).consumerMainThread((data, context) -> PacketHandler.handleRequestDiscordMentionsPacket(((NetworkEvent.Context)context.get()).getSender())).add();
            CHANNEL.messageBuilder(CustomPayloadPackets.DiscordMentionsPartPacket.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(CustomPayloadPackets.BasePartPacket::encode).decoder(CustomPayloadPackets.DiscordMentionsPartPacket::new).consumerMainThread((data, context) -> PacketHandler.handleDiscordMentionsPacket(data)).add();
            CHANNEL.messageBuilder(CustomPayloadPackets.ScreenshotPartPacketServer.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(CustomPayloadPackets.BasePartPacket::encode).decoder(CustomPayloadPackets.ScreenshotPartPacketServer::new).consumerMainThread((data, context) -> {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player == null) {
                    return;
                }
                PacketHandler.handleScreenshotPartPacketServerSide(data, player);
            }).add();
            CHANNEL.messageBuilder(CustomPayloadPackets.ScreenshotPartPacketClient.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(CustomPayloadPackets.BasePartPacket::encode).decoder(CustomPayloadPackets.ScreenshotPartPacketClient::new).consumerMainThread((data, context) -> PacketHandler.handleScreenshotPartPacketClientSide(data)).add();
            CHANNEL.messageBuilder(CustomPayloadPackets.DiscordEmojisPartPacket.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(CustomPayloadPackets.BasePartPacket::encode).decoder(CustomPayloadPackets.DiscordEmojisPartPacket::new).consumerMainThread((data, context) -> PacketHandler.handleDiscordEmojisPacket(data)).add();
            CHANNEL.messageBuilder(CustomPayloadPackets.RequestDiscordEmojisPacket.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(CustomPayloadPackets.BaseRequestPacket::encode).decoder(CustomPayloadPackets.RequestDiscordEmojisPacket::new).consumerMainThread((data, context) -> PacketHandler.handleRequestDiscordEmojisPacket(((NetworkEvent.Context)context.get()).getSender())).add();
            CHANNEL.messageBuilder(CustomPayloadPackets.DiscordStickersPartPacket.class, id++, NetworkDirection.PLAY_TO_CLIENT).encoder(CustomPayloadPackets.BasePartPacket::encode).decoder(CustomPayloadPackets.DiscordStickersPartPacket::new).consumerMainThread((data, context) -> PacketHandler.handleDiscordStickersPacket(data)).add();
            CHANNEL.messageBuilder(CustomPayloadPackets.RequestDiscordStickersPacket.class, id++, NetworkDirection.PLAY_TO_SERVER).encoder(CustomPayloadPackets.BaseRequestPacket::encode).decoder(CustomPayloadPackets.RequestDiscordStickersPacket::new).consumerMainThread((data, context) -> PacketHandler.handleRequestDiscordStickersPacket(((NetworkEvent.Context)context.get()).getSender())).add();
        });
    }

    public static void sendToServer(CustomPayloadPackets.CustomPacketPayload msg) {
        CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)msg);
    }

    public static void sendToPlayer(ServerPlayer player, CustomPayloadPackets.CustomPacketPayload msg) {
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }
}

