/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.markdown;

import com.denisnumb.discord_chat_mod.markdown.MarkdownStyle;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;

public class MarkdownPattern {
    public static final Pattern LINK = Pattern.compile("(?<!\\\\)\\[(.+?)\\]\\((https?://\\S+)\\)");
    public static final Pattern UNDERLINED_ITALIC = Pattern.compile("\u25ba(?<!\\\\)_(.+?)(?<!\\\\)_\u25ba");
    public static final Pattern UNDERLINED = Pattern.compile("(?<!\\\\)\u25ba(.+?)(?<!\\\\)\u25ba");
    public static final Pattern ITALIC_underline = Pattern.compile("(?<!\\\\)_(.+?)(?<!\\\\)_");
    public static final Pattern BOLD_ITALIC = Pattern.compile("\u25ac(?<!\\\\)\\*(.+?)(?<!\\\\)\\*\u25ac");
    public static final Pattern BOLD = Pattern.compile("(?<!\\\\)\u25ac(.+?)(?<!\\\\)\u25ac");
    public static final Pattern ITALIC_star = Pattern.compile("(?<!\\\\)\\*(.+?)(?<!\\\\)\\*");
    public static final Pattern STRIKETHROUGH = Pattern.compile("(?<!\\\\)~(?<!\\\\)~(.+?)(?<!\\\\)~(?<!\\\\)~");
    public static final Pattern OBFUSCATED = Pattern.compile("(?<!\\\\)\\|(?<!\\\\)\\|(.+?)(?<!\\\\)\\|(?<!\\\\)\\|");
    public static final Pattern URL = Pattern.compile("(https?://\\S+)");
    public static final Pattern DISCORD_MENTION = Pattern.compile("(?<!\\\\)<((?<!\\\\)([@#][!&]?\\d+)|(:.+?:\\d+))(?<!\\\\)>");
    public static final Pattern EMOJI = Pattern.compile(":[a-zA-Z0-9_]{2,}(~([1-9][0-9]*))?:");
    public static final Pattern COLOR_RANGE = Pattern.compile("(?<!\\\\)<([a-zA-Z]+|#[0-9a-fA-F]{3}|#[0-9a-fA-F]{6})(?<!\\\\)>(.+?)(?<!\\\\)<\\1(?<!\\\\)/(?<!\\\\)>");
    public static final Pattern COLOR_SINGLE = Pattern.compile("(?<!\\\\)<([a-zA-Z]+|#[0-9a-fA-F]{3}|#[0-9a-fA-F]{6})(?<!\\\\)/(?<!\\\\)>(\\S+)");
    public static final Pattern COLOR_OPEN = Pattern.compile("(?<!\\\\)<([a-zA-Z]+|#[0-9a-fA-F]{3}|#[0-9a-fA-F]{6})(?<!\\\\)>(.*?)(?=(?:<|$))");
    public static final HashMap<Pattern, MarkdownStyle> withStyle = new LinkedHashMap<Pattern, MarkdownStyle>(){
        {
            this.put(LINK, MarkdownStyle.LINK);
            this.put(UNDERLINED_ITALIC, MarkdownStyle.UNDERLINED_ITALIC);
            this.put(UNDERLINED, MarkdownStyle.UNDERLINED);
            this.put(ITALIC_underline, MarkdownStyle.ITALIC_underline);
            this.put(BOLD_ITALIC, MarkdownStyle.BOLD_ITALIC);
            this.put(BOLD, MarkdownStyle.BOLD);
            this.put(ITALIC_star, MarkdownStyle.ITALIC_star);
            this.put(STRIKETHROUGH, MarkdownStyle.STRIKETHROUGH);
            this.put(OBFUSCATED, MarkdownStyle.OBFUSCATED);
            this.put(URL, MarkdownStyle.URL);
            this.put(DISCORD_MENTION, MarkdownStyle.DISCORD_MENTION);
            this.put(EMOJI, MarkdownStyle.EMOJI);
            this.put(COLOR_RANGE, MarkdownStyle.COLOR_RANGE);
            this.put(COLOR_SINGLE, MarkdownStyle.COLOR_SINGLE);
            this.put(COLOR_OPEN, MarkdownStyle.COLOR_OPEN);
        }
    };

    public static boolean isStyleExceptAnother(MarkdownStyle style, MarkdownStyle another) {
        if (style == MarkdownStyle.COLOR_RANGE) {
            return another == MarkdownStyle.COLOR_OPEN || another == MarkdownStyle.COLOR_SINGLE;
        }
        if (style == MarkdownStyle.UNDERLINED_ITALIC) {
            return another == MarkdownStyle.UNDERLINED || another == MarkdownStyle.ITALIC_underline;
        }
        if (style == MarkdownStyle.BOLD_ITALIC) {
            return another == MarkdownStyle.BOLD || another == MarkdownStyle.ITALIC_star;
        }
        return false;
    }
}

