/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.markdown;

import com.denisnumb.discord_chat_mod.ColorUtils;
import com.denisnumb.discord_chat_mod.discord.model.DiscordMentionData;
import com.denisnumb.discord_chat_mod.markdown.MarkdownToken;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;

public class MarkdownToComponentConverter {
    private final MutableComponent result = Component.m_237119_();
    private final List<MarkdownToken> tokens;
    private final Map<String, DiscordMentionData> mentions;

    public MarkdownToComponentConverter(List<MarkdownToken> tokens) {
        this.tokens = tokens;
        this.mentions = Map.of();
    }

    public MarkdownToComponentConverter(List<MarkdownToken> tokens, Map<String, DiscordMentionData> mentions) {
        this.tokens = tokens;
        this.mentions = mentions;
    }

    public MutableComponent convertMarkdownTokensToComponent() {
        for (MarkdownToken token : this.tokens) {
            this.convertToken(token, false);
        }
        return this.result;
    }

    public MutableComponent convertMarkdownTokensWithSpecialCharsToComponent() {
        for (MarkdownToken token : this.tokens) {
            this.convertToken(token, true);
        }
        return this.result;
    }

    private void addPart(MarkdownToken token, String textPart) {
        MutableComponent component = Component.m_237113_((String)textPart);
        if (this.mentions.containsKey(textPart)) {
            String mentionString = textPart;
            DiscordMentionData mentionData = this.mentions.get(mentionString);
            textPart = mentionData.prettyMention;
            component = Component.m_237113_((String)textPart).m_130938_(style -> style.m_131148_(TextColor.m_131268_((String)mentionData.color)));
            if (mentionData.memberData != null) {
                component = component.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)mentionData.memberData.discordName))).m_131138_(mentionData.prettyMention));
            }
        }
        if (!textPart.isBlank()) {
            String finalTextPart = textPart;
            component = component.m_130938_(style -> {
                style = style.m_131136_(Boolean.valueOf(token.bold)).m_131155_(Boolean.valueOf(token.italic)).m_178522_(Boolean.valueOf(token.strikethrough)).m_131162_(Boolean.valueOf(token.underlined)).m_178524_(Boolean.valueOf(token.obfuscated));
                if (token.obfuscated) {
                    style = style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)finalTextPart)));
                }
                if (token.isColored()) {
                    style = style.m_178520_(token.color.intValue());
                }
                if (token.isUrl()) {
                    String hoverValue = token.obfuscated ? String.format("%s (%s)", finalTextPart, token.url) : token.url;
                    style = style.m_178520_(ColorUtils.Color.CHAT_LINK_COLOR).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, token.url)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)hoverValue)));
                }
                return style;
            });
        }
        this.result.m_7220_((Component)component);
    }

    private void convertToken(MarkdownToken token, boolean handleSpecialChars) {
        if (token.getInnerTokens().isEmpty() || handleSpecialChars && token.isSpecialCharacters) {
            this.addPart(token, token.text);
        } else {
            String textPart;
            int currentPos = 0;
            for (MarkdownToken innerToken : token.getInnerTokens()) {
                Matcher match = Pattern.compile(Pattern.quote(innerToken.rawText)).matcher(token.text.substring(currentPos));
                int startIndex = (match.find() ? match.start() : 0) + currentPos;
                if (startIndex > currentPos) {
                    String textPart2 = token.text.substring(currentPos, startIndex);
                    this.addPart(token, textPart2);
                }
                if (handleSpecialChars && innerToken.isSpecialCharacters) {
                    this.addPart(innerToken, innerToken.rawText);
                    currentPos = startIndex;
                    continue;
                }
                this.convertToken(innerToken, handleSpecialChars);
                currentPos = startIndex + innerToken.rawText.length();
            }
            if (currentPos < token.text.length() && !(textPart = token.text.substring(currentPos)).isBlank()) {
                this.addPart(token, textPart);
            }
        }
    }
}

