/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.markdown;

import com.denisnumb.discord_chat_mod.ColorUtils;
import java.util.List;

public class MarkdownToken {
    public String rawText;
    public String text;
    public String url = null;
    public boolean bold = false;
    public boolean italic = false;
    public boolean underlined = false;
    public boolean strikethrough = false;
    public boolean obfuscated = false;
    public boolean isMention = false;
    public Integer color = null;
    public boolean isSpecialCharacters = false;
    private List<MarkdownToken> innerTokens;

    public MarkdownToken(String rawText) {
        this(rawText, rawText);
    }

    public MarkdownToken(String rawText, String text) {
        this.rawText = rawText;
        this.text = text;
    }

    public boolean isUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean isColored() {
        return this.color != null;
    }

    public boolean hasNoMarkdown() {
        return !this.isUrl() && !this.bold && !this.italic && !this.underlined && !this.strikethrough && !this.obfuscated && !this.isMention && !this.isColored() && !this.isSpecialCharacters;
    }

    public List<MarkdownToken> getInnerTokens() {
        return this.innerTokens != null ? this.innerTokens : List.of();
    }

    public void setInnerTokens(List<MarkdownToken> tokens) {
        this.innerTokens = tokens;
        this.updateStyles();
    }

    public void updateStyles() {
        for (MarkdownToken innerToken : this.getInnerTokens()) {
            innerToken.combineStyles(this);
            innerToken.updateStyles();
        }
    }

    public void combineStyles(MarkdownToken another) {
        if (this.isSpecialCharacters) {
            return;
        }
        this.url = this.isUrl() ? this.url : another.url;
        this.bold |= another.bold;
        this.italic |= another.italic;
        this.underlined |= another.underlined;
        this.strikethrough |= another.strikethrough;
        this.obfuscated |= another.obfuscated;
        this.color = this.isColored() ? this.color : another.color;
    }

    public String toString() {
        if (this.isSpecialCharacters) {
            return this.rawText;
        }
        StringBuilder result = new StringBuilder("[");
        result.append(String.format("rawText=\"%s\", text=\"%s\"", this.rawText, this.text));
        if (this.isUrl()) {
            result.append(String.format(", url=\"%s\"", this.url));
        }
        if (this.bold) {
            result.append(", bold");
        }
        if (this.italic) {
            result.append(", italic");
        }
        if (this.underlined) {
            result.append(", underlined");
        }
        if (this.strikethrough) {
            result.append(", strikethrough");
        }
        if (this.obfuscated) {
            result.append(", obfuscated");
        }
        if (this.isMention) {
            result.append(", isMention");
        }
        if (this.isColored()) {
            result.append(String.format(", color=\"%s\"", ColorUtils.getHexColor(this.color)));
        }
        result.append("]");
        if (!this.getInnerTokens().isEmpty()) {
            for (MarkdownToken innerToken : this.getInnerTokens()) {
                result.append("\n\t").append(innerToken.toString());
            }
        }
        return result.toString();
    }
}

