/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.mixin;

import com.denisnumb.discord_chat_mod.LocaleProvider;
import com.denisnumb.discord_chat_mod.MinecraftClientEvents;
import com.denisnumb.discord_chat_mod.chat_images.ImageStorage;
import com.denisnumb.discord_chat_mod.chat_images.model.AbstractImage;
import com.denisnumb.discord_chat_mod.chat_images.model.AnimatedImage;
import com.denisnumb.discord_chat_mod.chat_images.model.Image;
import com.denisnumb.discord_chat_mod.chat_images.model.ImageSize;
import com.denisnumb.discord_chat_mod.config.ConfigProvider;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatComponent.class})
public abstract class ChatComponentMixin {
    @Shadow
    @Final
    private Minecraft f_93758_;
    @Shadow
    @Final
    private List<GuiMessage.Line> f_93761_;
    @Shadow
    private int f_93763_;
    @Shadow
    @Final
    private List<GuiMessage> f_93760_;

    @Shadow
    protected abstract int m_240691_();

    @Shadow
    protected abstract boolean m_93818_();

    @Shadow
    public abstract double m_93815_();

    @Shadow
    public abstract int m_93816_();

    @ModifyArg(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"), index=0, require=0)
    private Component handleChatMessageClient(Component component) {
        return MinecraftClientEvents.handleChatMessage(component);
    }

    @Unique
    private List<String> discord_minecraft_chat$getComponentUrls(Component component) {
        return component.m_240407_().stream().filter(comp -> {
            ClickEvent clickEvent = comp.m_7383_().m_131182_();
            return clickEvent != null && clickEvent.m_130622_() == ClickEvent.Action.OPEN_URL;
        }).map(comp -> comp.m_7383_().m_131182_().m_130623_()).toList();
    }

    @Unique
    private int discord_minecraft_chat$getImageLinesCount(int imageHeight) {
        return Mth.m_14167_((float)((float)imageHeight / (float)this.m_240691_())) + 1;
    }

    @Unique
    private int discord_minecraft_chat$getGuiMessageIndexByTrimmedMessageIndex(int targetIndex) {
        int messageIndex = -1;
        for (int i = 0; i <= targetIndex; ++i) {
            if (!this.f_93761_.get(i).f_240367_()) continue;
            ++messageIndex;
        }
        return messageIndex;
    }

    @ModifyConstant(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"}, constant={@Constant(intValue=100)}, require=0)
    private int modifyAddMessageMessageLimit(int original) {
        return ConfigProvider.getConfig().maxChatHistory();
    }

    @Inject(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"}, at={@At(value="INVOKE", target="Ljava/util/List;add(ILjava/lang/Object;)V", ordinal=0, shift=At.Shift.BY, by=2)})
    private void removeOldFromTrimmedMessages(Component message, MessageSignature signature, int addedTime, GuiMessageTag tag, boolean onlyTrimmed, CallbackInfo ci) {
        while (this.f_93761_.size() > ConfigProvider.getConfig().maxChatHistory()) {
            int parentAddedTime = this.f_93761_.get(this.f_93761_.size() - 1).f_240350_();
            do {
                this.f_93761_.remove(this.f_93761_.size() - 1);
            } while (this.f_93761_.get(this.f_93761_.size() - 1).f_240350_() == parentAddedTime);
        }
    }

    @Inject(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"}, at={@At(value="INVOKE", target="Ljava/util/List;add(ILjava/lang/Object;)V", ordinal=1, shift=At.Shift.AFTER)})
    private void removeOldFromAllMessages(Component message, MessageSignature signature, int addedTime, GuiMessageTag tag, boolean onlyTrimmed, CallbackInfo ci) {
        while (this.f_93760_.size() > ConfigProvider.getConfig().maxChatHistory()) {
            int parentAddedTime = this.f_93760_.get(this.f_93760_.size() - 1).f_90786_();
            do {
                this.f_93760_.remove(this.f_93760_.size() - 1);
            } while (this.f_93760_.get(this.f_93760_.size() - 1).f_90786_() == parentAddedTime);
        }
    }

    @Inject(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"}, at={@At(value="TAIL")})
    private void addMessageWithImage(Component message, MessageSignature signature, int addedTime, GuiMessageTag tag, boolean onlyTrimmed, CallbackInfo ci) {
        List<String> componentUrls = this.discord_minecraft_chat$getComponentUrls(message);
        if (componentUrls.isEmpty()) {
            return;
        }
        ImageStorage.loadImagesParallel(componentUrls, () -> this.f_93761_.size(), () -> this.f_93760_.size()).thenAccept(loadResult -> {
            int oldTrimmedSize = loadResult.trimmedMessagesSize();
            int oldAllSize = loadResult.allMessagesSize();
            int trimmedIndex = this.f_93761_.size() > oldTrimmedSize ? this.f_93761_.size() - oldTrimmedSize : 0;
            int allIndex = this.f_93760_.size() > oldAllSize ? this.f_93760_.size() - oldAllSize : 0;
            for (AbstractImage image : Lists.reverse(loadResult.images())) {
                int i;
                if (image == null) continue;
                int linesCount = this.discord_minecraft_chat$getImageLinesCount(image.imageSize.height());
                MutableComponent imageComponent = Component.m_237113_((String)" ".repeat(image.imageSize.width() / this.f_93758_.f_91062_.m_92895_(" "))).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)LocaleProvider.getTranslateClient("discord_chat_mod.command.click_to_open_image")))).m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "open_image " + image.url)));
                FormattedCharSequence imageCharSequence = imageComponent.m_7532_();
                for (i = 0; i < linesCount; ++i) {
                    this.f_93761_.add(trimmedIndex, new GuiMessage.Line(addedTime, imageCharSequence, tag, true));
                }
                trimmedIndex += linesCount;
                if (onlyTrimmed) continue;
                for (i = 0; i < linesCount; ++i) {
                    this.f_93760_.add(allIndex, new GuiMessage(addedTime, (Component)imageComponent, signature, tag));
                }
                allIndex += linesCount;
            }
        });
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void render(GuiGraphics graphics, int currentTime, int mouseX, int mouseY, CallbackInfo ci) {
        HashMap<Integer, List<String>> allChatUrls = new HashMap<Integer, List<String>>();
        for (int i = 0; i < this.f_93760_.size(); ++i) {
            GuiMessage guiMessage = this.f_93760_.get(i);
            List<String> urls2 = this.discord_minecraft_chat$getComponentUrls(guiMessage.f_240363_());
            if (urls2.isEmpty()) continue;
            allChatUrls.put(i, urls2);
        }
        if (allChatUrls.isEmpty()) {
            return;
        }
        int chatBottomY = Mth.m_14143_((float)((float)(graphics.m_280206_() - 40) / (float)this.m_93815_()));
        int lineHeight = this.m_240691_();
        int chatTopY = chatBottomY - lineHeight * this.m_93816_();
        boolean isChatFocused = this.m_93818_();
        HashMap<Integer, Integer> messagesY = new HashMap<Integer, Integer>();
        int i = 0;
        while (i + this.f_93763_ < this.f_93761_.size()) {
            int messageIndex = i + this.f_93763_;
            int guiMessageIndex = this.discord_minecraft_chat$getGuiMessageIndexByTrimmedMessageIndex(messageIndex);
            int messageY = chatBottomY - i * lineHeight;
            if (this.f_93761_.get(messageIndex).f_240367_()) {
                messagesY.put(guiMessageIndex, messageY);
            }
            ++i;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(4.0f, 0.0f, 50.0f);
        for (Map.Entry entry : allChatUrls.entrySet()) {
            int messageIndex = (Integer)entry.getKey();
            GuiMessage guiMessage = this.f_93760_.get(messageIndex);
            List urls3 = (List)entry.getValue();
            if (!messagesY.containsKey(messageIndex) || currentTime - guiMessage.f_90786_() >= 200 && !isChatFocused) continue;
            int messageY = (Integer)messagesY.get(messageIndex);
            int offset = 0;
            for (String imageUrl : urls3) {
                int endY;
                int imageHeight;
                ResourceLocation resourceLocation;
                if (!ImageStorage.IMAGE_CACHE.containsKey(imageUrl)) continue;
                AbstractImage abstractImage = ImageStorage.IMAGE_CACHE.get(imageUrl);
                ImageSize imageSize = abstractImage.imageSize;
                if (abstractImage.isSpoilerAndNotOpened()) {
                    resourceLocation = abstractImage.spoilerResourceLocation;
                } else if (abstractImage instanceof AnimatedImage) {
                    AnimatedImage gif = (AnimatedImage)abstractImage;
                    resourceLocation = gif.getCurrentFrame();
                } else {
                    resourceLocation = ((Image)abstractImage).resourceLocation;
                }
                ResourceLocation resourceLocation2 = resourceLocation;
                int imageWidth = imageSize.width();
                int visibleHeight = imageHeight = imageSize.height();
                int startY = messageY + offset + lineHeight / 2;
                int startV = 0;
                if (startY < chatTopY) {
                    startV = Math.abs(chatTopY - startY);
                    visibleHeight -= startV;
                    startY = chatTopY;
                }
                if ((endY = startY + imageHeight) > chatBottomY) {
                    visibleHeight -= Math.abs(endY - chatBottomY);
                }
                graphics.m_280163_(resourceLocation2, 0, startY, 0.0f, (float)startV, imageWidth, visibleHeight, imageWidth, imageHeight);
                if (abstractImage.isSpoilerAndNotOpened()) {
                    MutableComponent spoilerText = Component.m_237113_((String)LocaleProvider.getTranslateClient("discord_chat_mod.spoiler")).m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
                    float maxScale = 1.5f;
                    float scaleX = (float)imageWidth / 128.0f * maxScale;
                    float scaleY = (float)imageHeight / 72.0f * maxScale;
                    float scale = Mth.m_14036_((float)Math.min(scaleX, scaleY), (float)0.5f, (float)maxScale);
                    int originalTextWidth = this.f_93758_.f_91062_.m_92852_((FormattedText)spoilerText);
                    Objects.requireNonNull(this.f_93758_.f_91062_);
                    int originalTextHeight = 9;
                    int centerX = imageWidth / 2;
                    int fullCenterY = messageY + offset + lineHeight / 2 + imageHeight / 2;
                    if (fullCenterY >= chatTopY && fullCenterY <= chatBottomY) {
                        int textX = centerX - (int)((float)originalTextWidth * scale / 2.0f);
                        int textY = fullCenterY - (int)((float)originalTextHeight * scale / 2.0f);
                        graphics.m_280168_().m_85836_();
                        graphics.m_280168_().m_252880_((float)textX, (float)textY, 0.0f);
                        graphics.m_280168_().m_85841_(scale, scale, 1.0f);
                        graphics.m_280614_(this.f_93758_.f_91062_, (Component)spoilerText, 0, 0, 0xFFFFFF, true);
                        graphics.m_280168_().m_85849_();
                    }
                }
                offset += imageHeight + lineHeight;
            }
        }
        graphics.m_280168_().m_85849_();
    }
}

