/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.mixin;

import com.denisnumb.discord_chat_mod.chat_images.model.AbstractImage;
import com.denisnumb.discord_chat_mod.chat_images.model.AnimatedImage;
import com.denisnumb.discord_chat_mod.chat_images.model.Image;
import com.denisnumb.discord_chat_mod.config.ConfigProvider;
import com.denisnumb.discord_chat_mod.discord.CustomEmojiProvider;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={GuiGraphics.class})
public abstract class GuiGraphicsMixin {
    @Unique
    private static final Pattern EMOJI_PATTERN = Pattern.compile(":([a-zA-Z0-9_]{2,}(~([1-9][0-9]*))?):");
    @Shadow
    @Final
    private PoseStack f_279612_;
    @Shadow
    @Final
    private MultiBufferSource.BufferSource f_279627_;

    @Shadow
    public abstract void m_280163_(ResourceLocation var1, int var2, int var3, float var4, float var5, int var6, int var7, int var8, int var9);

    @Shadow
    private void m_286081_() {
    }

    @Unique
    private static FormattedCharSequence discord_minecraft_chat$substringFormatted(FormattedCharSequence text, int start, int end) {
        if (start >= end || start < 0) {
            return FormattedCharSequence.f_13691_;
        }
        ArrayList parts = new ArrayList();
        AtomicInteger index = new AtomicInteger();
        text.m_13731_((i, style, codePoint) -> {
            if (index.get() >= start && index.get() < end) {
                parts.add(FormattedCharSequence.m_13693_((int)codePoint, (Style)style));
            }
            index.getAndIncrement();
            return true;
        });
        return FormattedCharSequence.m_13722_(parts);
    }

    @Unique
    private int discord_chat_mod$drawInBatch(Font font, FormattedCharSequence text, int x, int y, int color, boolean dropShadow) {
        int result = font.m_272191_(text, (float)x, (float)y, color, dropShadow, this.f_279612_.m_85850_().m_252922_(), (MultiBufferSource)this.f_279627_, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.m_286081_();
        return result;
    }

    @Unique
    private int discord_chat_mod$drawInBatch(Font font, @Nullable String string, int x, int y, int color, boolean dropShadow) {
        if (string == null) {
            return 0;
        }
        int result = font.m_272078_(string, (float)x, (float)y, color, dropShadow, this.f_279612_.m_85850_().m_252922_(), (MultiBufferSource)this.f_279627_, Font.DisplayMode.NORMAL, 0, 0xF000F0, font.m_92718_());
        this.m_286081_();
        return result;
    }

    @Inject(method={"drawString(Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIZ)I"}, at={@At(value="HEAD")}, cancellable=true)
    public void drawString(Font font, String text, int x, int y, int color, boolean dropShadow, CallbackInfoReturnable<Integer> cir) {
        Matcher matcher = EMOJI_PATTERN.matcher(text);
        if (ConfigProvider.getConfig().isEmojifulCompatibilityEnabled() || !matcher.find() || CustomEmojiProvider.CLIENT_EMOJI_CACHE.isEmpty()) {
            cir.setReturnValue((Object)this.discord_chat_mod$drawInBatch(font, text, x, y, color, dropShadow));
            return;
        }
        int currentX = x;
        int lastEnd = 0;
        do {
            AbstractImage abstractImage = CustomEmojiProvider.CLIENT_EMOJI_CACHE.get(matcher.group(1));
            if (matcher.start() > lastEnd) {
                String before = text.substring(lastEnd, matcher.start());
                currentX = this.discord_chat_mod$drawInBatch(font, before, currentX, y, color, dropShadow);
            }
            if (abstractImage != null) {
                ResourceLocation resourceLocation;
                if (abstractImage instanceof AnimatedImage) {
                    AnimatedImage emojiGif = (AnimatedImage)abstractImage;
                    resourceLocation = emojiGif.getCurrentFrame();
                } else {
                    resourceLocation = ((Image)abstractImage).resourceLocation;
                }
                ResourceLocation emoji = resourceLocation;
                Minecraft.m_91087_().m_91097_().m_174784_(emoji);
                int emojiSize = 9;
                this.m_280163_(emoji, currentX, y - 1, 0.0f, 0.0f, emojiSize, emojiSize, emojiSize, emojiSize);
                currentX += emojiSize;
            } else {
                String notFound = text.substring(matcher.start(), matcher.end());
                currentX = this.discord_chat_mod$drawInBatch(font, notFound, currentX, y, color, dropShadow);
            }
            lastEnd = matcher.end();
        } while (matcher.find());
        if (lastEnd < text.length()) {
            String rest = text.substring(lastEnd);
            currentX = this.discord_chat_mod$drawInBatch(font, rest, currentX, y, color, dropShadow);
        }
        cir.setReturnValue((Object)currentX);
    }

    @Inject(method={"drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/util/FormattedCharSequence;IIIZ)I"}, at={@At(value="HEAD")}, cancellable=true)
    public void drawString(Font font, FormattedCharSequence text, int x, int y, int color, boolean dropShadow, CallbackInfoReturnable<Integer> cir) {
        StringBuilder rawTextBuilder = new StringBuilder();
        text.m_13731_((index, style, codePoint) -> {
            rawTextBuilder.appendCodePoint(codePoint);
            return true;
        });
        String rawText = rawTextBuilder.toString();
        Matcher matcher = EMOJI_PATTERN.matcher(rawText);
        if (ConfigProvider.getConfig().isEmojifulCompatibilityEnabled() || !matcher.find() || CustomEmojiProvider.CLIENT_EMOJI_CACHE.isEmpty()) {
            cir.setReturnValue((Object)this.discord_chat_mod$drawInBatch(font, text, x, y, color, dropShadow));
            return;
        }
        int currentX = x;
        int lastEnd = 0;
        do {
            AbstractImage abstractImage = CustomEmojiProvider.CLIENT_EMOJI_CACHE.get(matcher.group(1));
            if (matcher.start() > lastEnd) {
                FormattedCharSequence beforeSeq = GuiGraphicsMixin.discord_minecraft_chat$substringFormatted(text, lastEnd, matcher.start());
                currentX = this.discord_chat_mod$drawInBatch(font, beforeSeq, currentX, y, color, dropShadow);
            }
            if (abstractImage != null) {
                ResourceLocation resourceLocation;
                if (abstractImage instanceof AnimatedImage) {
                    AnimatedImage emojiGif = (AnimatedImage)abstractImage;
                    resourceLocation = emojiGif.getCurrentFrame();
                } else {
                    resourceLocation = ((Image)abstractImage).resourceLocation;
                }
                ResourceLocation emoji = resourceLocation;
                Minecraft.m_91087_().m_91097_().m_174784_(emoji);
                int emojiSize = 9;
                this.m_280163_(emoji, currentX, y - 1, 0.0f, 0.0f, emojiSize, emojiSize, emojiSize, emojiSize);
                currentX += emojiSize;
            } else {
                FormattedCharSequence notFound = GuiGraphicsMixin.discord_minecraft_chat$substringFormatted(text, matcher.start(), matcher.end());
                currentX = this.discord_chat_mod$drawInBatch(font, notFound, currentX, y, color, dropShadow);
            }
            lastEnd = matcher.end();
        } while (matcher.find());
        if (lastEnd < rawText.length()) {
            FormattedCharSequence restSeq = GuiGraphicsMixin.discord_minecraft_chat$substringFormatted(text, lastEnd, Integer.MAX_VALUE);
            currentX = this.discord_chat_mod$drawInBatch(font, restSeq, currentX, y, color, dropShadow);
        }
        cir.setReturnValue((Object)currentX);
    }
}

