/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.network.sticker;

import com.denisnumb.discord_chat_mod.discord.StickersProvider;
import com.denisnumb.discord_chat_mod.network.BigPacketsTransceiver;
import com.denisnumb.discord_chat_mod.network.CustomPayloadPackets;
import com.denisnumb.discord_chat_mod.network.PlatformPacketDistributor;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;

public class DiscordStickersTransceiver {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<Long, ArrayList<byte[]>> receivedParts = new HashMap<Long, ArrayList<byte[]>>();
    private static final Gson gson = new Gson();
    private static final Type gsonType = new TypeToken<Map<String, String>>(){}.getType();
    private static long lastRequestTime = 0L;

    public static void requestDiscordStickers() {
        long requestTime = System.currentTimeMillis();
        if (requestTime - lastRequestTime < 30000L) {
            return;
        }
        lastRequestTime = requestTime;
        try {
            PlatformPacketDistributor.sendToServer(new CustomPayloadPackets.RequestDiscordStickersPacket());
        }
        catch (Exception e) {
            LOGGER.error("RequestDiscordStickersError: " + e.getMessage());
        }
    }

    public static void sendDiscordStickersDataToPlayer(ServerPlayer player) {
        long sendTime = System.currentTimeMillis();
        byte[] data = gson.toJson(StickersProvider.getNameToUrlMap(), gsonType).getBytes();
        BigPacketsTransceiver.send(data, (partIndex, totalParts, part) -> PlatformPacketDistributor.sendToPlayer(player, new CustomPayloadPackets.DiscordStickersPartPacket(sendTime, partIndex, totalParts, part)));
    }

    public static void receiveDiscordStickersPart(CustomPayloadPackets.DiscordStickersPartPacket packet) {
        BigPacketsTransceiver.receivePart(receivedParts, packet.sendTime, packet.partIndex, packet.totalParts, packet.data).ifPresent(data -> StickersProvider.loadClient((Map)gson.fromJson(new String((byte[])data), gsonType)));
    }
}

