/*
 * Decompiled with CFR 0.152.
 */
package com.shadow.com.twelvemonkeys.imageio.plugins.webp.lossless;

import com.shadow.com.twelvemonkeys.imageio.plugins.webp.lossless.Transform;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

final class ColorTransform
implements Transform {
    private final Raster data;
    private final byte bits;

    public ColorTransform(Raster raster, byte by) {
        this.data = raster;
        this.bits = by;
    }

    @Override
    public void applyInverse(WritableRaster writableRaster) {
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        byte[] byArray = new byte[4];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.data.getDataElements(j >> this.bits, i >> this.bits, byArray);
                ColorTransformElement colorTransformElement = new ColorTransformElement(byArray);
                writableRaster.getDataElements(j, i, byArray);
                colorTransformElement.inverseTransform(byArray);
                writableRaster.setDataElements(j, i, byArray);
            }
        }
    }

    private static void colorTransform(int n, int n2, int n3, ColorTransformElement colorTransformElement, int[] nArray) {
        int n4 = n;
        int n5 = n2;
        n5 += ColorTransform.colorTransformDelta((byte)colorTransformElement.green_to_blue, (byte)n3);
        nArray[0] = (n4 += ColorTransform.colorTransformDelta((byte)colorTransformElement.green_to_red, (byte)n3)) & 0xFF;
        nArray[1] = (n5 += ColorTransform.colorTransformDelta((byte)colorTransformElement.red_to_blue, (byte)n)) & 0xFF;
    }

    private static byte colorTransformDelta(byte by, byte by2) {
        return (byte)(by * by2 >> 5);
    }

    private static final class ColorTransformElement {
        final int green_to_red;
        final int green_to_blue;
        final int red_to_blue;

        ColorTransformElement(byte[] byArray) {
            this.green_to_red = byArray[2];
            this.green_to_blue = byArray[1];
            this.red_to_blue = byArray[0];
        }

        private void inverseTransform(byte[] byArray) {
            int n = byArray[0];
            int n2 = byArray[2];
            n2 += ColorTransform.colorTransformDelta((byte)this.green_to_blue, byArray[1]);
            byArray[0] = (byte)(n & 0xFF);
            byArray[2] = (byte)((n2 += ColorTransform.colorTransformDelta((byte)this.red_to_blue, (byte)(n += ColorTransform.colorTransformDelta((byte)this.green_to_red, byArray[1])))) & 0xFF);
        }
    }
}

