/*
 * Decompiled with CFR 0.152.
 */
package com.shadow.net.dv8tion.jda.api.components.filedisplay;

import com.shadow.net.dv8tion.jda.api.components.Component;
import com.shadow.net.dv8tion.jda.api.components.MessageTopLevelComponent;
import com.shadow.net.dv8tion.jda.api.components.ResolvedMedia;
import com.shadow.net.dv8tion.jda.api.components.container.ContainerChildComponent;
import com.shadow.net.dv8tion.jda.api.utils.FileUpload;
import com.shadow.net.dv8tion.jda.internal.components.filedisplay.FileDisplayFileUpload;
import com.shadow.net.dv8tion.jda.internal.components.filedisplay.FileDisplayImpl;
import com.shadow.net.dv8tion.jda.internal.utils.Checks;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface FileDisplay
extends Component,
MessageTopLevelComponent,
ContainerChildComponent {
    @Nonnull
    public static FileDisplay fromFile(@Nonnull FileUpload file) {
        Checks.notNull(file, "FileUpload");
        return new FileDisplayFileUpload(file);
    }

    @Nonnull
    public static FileDisplay fromFileName(@Nonnull String fileName) {
        Checks.notNull(fileName, "File name");
        return new FileDisplayImpl("attachment://" + fileName);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public FileDisplay withUniqueId(int var1);

    @Nonnull
    @CheckReturnValue
    public FileDisplay withSpoiler(boolean var1);

    @Nonnull
    public String getUrl();

    @Nullable
    public ResolvedMedia getResolvedMedia();

    public boolean isSpoiler();
}

