/*
 * Decompiled with CFR 0.152.
 */
package com.shadow.net.dv8tion.jda.api.components.separator;

import com.shadow.net.dv8tion.jda.api.components.Component;
import com.shadow.net.dv8tion.jda.api.components.MessageTopLevelComponent;
import com.shadow.net.dv8tion.jda.api.components.container.ContainerChildComponent;
import com.shadow.net.dv8tion.jda.internal.components.separator.SeparatorImpl;
import com.shadow.net.dv8tion.jda.internal.utils.Checks;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public interface Separator
extends Component,
MessageTopLevelComponent,
ContainerChildComponent {
    @Nonnull
    public static Separator createDivider(@Nonnull Spacing spacing) {
        return Separator.create(true, spacing);
    }

    @Nonnull
    public static Separator createInvisible(@Nonnull Spacing spacing) {
        return Separator.create(false, spacing);
    }

    @Nonnull
    public static Separator create(boolean isDivider, @Nonnull Spacing spacing) {
        Checks.notNull((Object)spacing, "Spacing");
        return new SeparatorImpl(spacing, isDivider);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public Separator withUniqueId(int var1);

    @Nonnull
    @CheckReturnValue
    public Separator withDivider(boolean var1);

    @Nonnull
    @CheckReturnValue
    public Separator withSpacing(@Nonnull Spacing var1);

    public boolean isDivider();

    @Nonnull
    public Spacing getSpacing();

    public static enum Spacing {
        UNKNOWN(-1),
        SMALL(1),
        LARGE(2);

        private final int key;

        private Spacing(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        @Nonnull
        public static Spacing fromKey(int type) {
            for (Spacing t : Spacing.values()) {
                if (t.key != type) continue;
                return t;
            }
            return UNKNOWN;
        }
    }
}

