/*
 * Decompiled with CFR 0.152.
 */
package com.shadow.net.dv8tion.jda.api.entities;

import com.shadow.net.dv8tion.jda.api.JDA;
import com.shadow.net.dv8tion.jda.api.components.MessageTopLevelComponent;
import com.shadow.net.dv8tion.jda.api.components.tree.ComponentTree;
import com.shadow.net.dv8tion.jda.api.entities.ISnowflake;
import com.shadow.net.dv8tion.jda.api.entities.IncomingWebhookClient;
import com.shadow.net.dv8tion.jda.api.entities.MessageEmbed;
import com.shadow.net.dv8tion.jda.api.entities.Webhook;
import com.shadow.net.dv8tion.jda.api.requests.restaction.WebhookMessageCreateAction;
import com.shadow.net.dv8tion.jda.api.requests.restaction.WebhookMessageDeleteAction;
import com.shadow.net.dv8tion.jda.api.requests.restaction.WebhookMessageEditAction;
import com.shadow.net.dv8tion.jda.api.requests.restaction.WebhookMessageRetrieveAction;
import com.shadow.net.dv8tion.jda.api.utils.AttachedFile;
import com.shadow.net.dv8tion.jda.api.utils.FileUpload;
import com.shadow.net.dv8tion.jda.api.utils.MiscUtil;
import com.shadow.net.dv8tion.jda.api.utils.messages.MessageCreateData;
import com.shadow.net.dv8tion.jda.api.utils.messages.MessageEditData;
import com.shadow.net.dv8tion.jda.api.utils.messages.MessagePollData;
import com.shadow.net.dv8tion.jda.internal.requests.IncomingWebhookClientImpl;
import com.shadow.net.dv8tion.jda.internal.utils.Checks;
import com.shadow.net.dv8tion.jda.internal.utils.Helpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface WebhookClient<T>
extends ISnowflake {
    @Nullable
    public String getToken();

    @Nonnull
    public JDA getJDA();

    @Nonnull
    @CheckReturnValue
    public WebhookMessageCreateAction<T> sendMessage(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    public WebhookMessageCreateAction<T> sendMessage(@Nonnull MessageCreateData var1);

    @Nonnull
    @CheckReturnValue
    public WebhookMessageCreateAction<T> sendMessagePoll(@Nonnull MessagePollData var1);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageCreateAction<T> sendMessageFormat(@Nonnull String format, Object ... args2) {
        Checks.notNull(format, "Format String");
        return this.sendMessage(String.format(format, args2));
    }

    @Nonnull
    @CheckReturnValue
    public WebhookMessageCreateAction<T> sendMessageEmbeds(@Nonnull Collection<? extends MessageEmbed> var1);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageCreateAction<T> sendMessageEmbeds(@Nonnull MessageEmbed embed, MessageEmbed ... embeds) {
        Checks.notNull(embed, "MessageEmbeds");
        Checks.noneNull(embeds, "MessageEmbeds");
        ArrayList<MessageEmbed> embedList = new ArrayList<MessageEmbed>();
        embedList.add(embed);
        Collections.addAll(embedList, embeds);
        return this.sendMessageEmbeds(embedList);
    }

    @Nonnull
    @CheckReturnValue
    public WebhookMessageCreateAction<T> sendMessageComponents(@Nonnull Collection<? extends MessageTopLevelComponent> var1);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageCreateAction<T> sendMessageComponents(@Nonnull MessageTopLevelComponent component, MessageTopLevelComponent ... other) {
        Checks.notNull(component, "MessageTopLevelComponent");
        Checks.noneNull(other, "MessageTopLevelComponents");
        return this.sendMessageComponents(Helpers.mergeVararg(component, other));
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageCreateAction<T> sendMessageComponents(@Nonnull ComponentTree<? extends MessageTopLevelComponent> tree) {
        Checks.notNull(tree, "ComponentTree");
        return this.sendMessageComponents(tree.getComponents());
    }

    @Nonnull
    @CheckReturnValue
    public WebhookMessageCreateAction<T> sendFiles(@Nonnull Collection<? extends FileUpload> var1);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageCreateAction<T> sendFiles(FileUpload ... files) {
        Checks.noneNull(files, "Files");
        Checks.notEmpty(files, "Files");
        return this.sendFiles(Arrays.asList(files));
    }

    @Nonnull
    @CheckReturnValue
    public WebhookMessageEditAction<T> editMessageById(@Nonnull String var1, @Nonnull String var2);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageById(long messageId, @Nonnull String content) {
        return this.editMessageById(Long.toUnsignedString(messageId), content);
    }

    @Nonnull
    @CheckReturnValue
    public WebhookMessageEditAction<T> editMessageById(@Nonnull String var1, @Nonnull MessageEditData var2);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageById(long messageId, @Nonnull MessageEditData message) {
        return this.editMessageById(Long.toUnsignedString(messageId), message);
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageFormatById(@Nonnull String messageId, @Nonnull String format, Object ... args2) {
        Checks.notNull(format, "Format String");
        return this.editMessageById(messageId, String.format(format, args2));
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageFormatById(long messageId, @Nonnull String format, Object ... args2) {
        return this.editMessageFormatById(Long.toUnsignedString(messageId), format, args2);
    }

    @Nonnull
    @CheckReturnValue
    public WebhookMessageEditAction<T> editMessageEmbedsById(@Nonnull String var1, @Nonnull Collection<? extends MessageEmbed> var2);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageEmbedsById(long messageId, @Nonnull Collection<? extends MessageEmbed> embeds) {
        return this.editMessageEmbedsById(Long.toUnsignedString(messageId), embeds);
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageEmbedsById(@Nonnull String messageId, MessageEmbed ... embeds) {
        Checks.noneNull(embeds, "MessageEmbeds");
        return this.editMessageEmbedsById(messageId, Arrays.asList(embeds));
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageEmbedsById(long messageId, MessageEmbed ... embeds) {
        return this.editMessageEmbedsById(Long.toUnsignedString(messageId), embeds);
    }

    @Nonnull
    @CheckReturnValue
    public WebhookMessageEditAction<T> editMessageComponentsById(@Nonnull String var1, @Nonnull Collection<? extends MessageTopLevelComponent> var2);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageComponentsById(long messageId, @Nonnull Collection<? extends MessageTopLevelComponent> components) {
        return this.editMessageComponentsById(Long.toUnsignedString(messageId), components);
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageComponentsById(@Nonnull String messageId, MessageTopLevelComponent ... components) {
        Checks.noneNull(components, "MessageTopLevelComponents");
        return this.editMessageComponentsById(messageId, Arrays.asList(components));
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageComponentsById(long messageId, MessageTopLevelComponent ... components) {
        return this.editMessageComponentsById(Long.toUnsignedString(messageId), components);
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageComponentsById(@Nonnull String messageId, @Nonnull ComponentTree<? extends MessageTopLevelComponent> tree) {
        Checks.notNull(tree, "ComponentTree");
        return this.editMessageComponentsById(messageId, tree.getComponents());
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageComponentsById(long messageId, @Nonnull ComponentTree<? extends MessageTopLevelComponent> tree) {
        Checks.notNull(tree, "ComponentTree");
        return this.editMessageComponentsById(messageId, tree.getComponents());
    }

    @Nonnull
    @CheckReturnValue
    public WebhookMessageEditAction<T> editMessageAttachmentsById(@Nonnull String var1, @Nonnull Collection<? extends AttachedFile> var2);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageAttachmentsById(@Nonnull String messageId, AttachedFile ... attachments) {
        Checks.noneNull(attachments, "Attachments");
        return this.editMessageAttachmentsById(messageId, Arrays.asList(attachments));
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageAttachmentsById(long messageId, @Nonnull Collection<? extends AttachedFile> attachments) {
        return this.editMessageAttachmentsById(Long.toUnsignedString(messageId), attachments);
    }

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageEditAction<T> editMessageAttachmentsById(long messageId, AttachedFile ... attachments) {
        return this.editMessageAttachmentsById(Long.toUnsignedString(messageId), attachments);
    }

    @Nonnull
    @CheckReturnValue
    public WebhookMessageDeleteAction deleteMessageById(@Nonnull String var1);

    @Nonnull
    @CheckReturnValue
    default public WebhookMessageDeleteAction deleteMessageById(long messageId) {
        return this.deleteMessageById(Long.toUnsignedString(messageId));
    }

    @Nonnull
    @CheckReturnValue
    public WebhookMessageRetrieveAction retrieveMessageById(@Nonnull String var1);

    @Nonnull
    public static IncomingWebhookClient createClient(@Nonnull JDA api, @Nonnull String url) {
        Checks.notNull(url, "URL");
        Matcher matcher = Webhook.WEBHOOK_URL.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Provided invalid webhook URL");
        }
        String id = matcher.group(1);
        String token = matcher.group(2);
        return WebhookClient.createClient(api, id, token);
    }

    @Nonnull
    public static IncomingWebhookClient createClient(@Nonnull JDA api, @Nonnull String webhookId, @Nonnull String webhookToken) {
        Checks.notNull(api, "JDA");
        Checks.notBlank(webhookToken, "Token");
        return new IncomingWebhookClientImpl(MiscUtil.parseSnowflake(webhookId), webhookToken, api);
    }
}

