/*
 * Decompiled with CFR 0.152.
 */
package com.shadow.net.dv8tion.jda.api.interactions.callbacks;

import com.shadow.net.dv8tion.jda.api.components.MessageTopLevelComponent;
import com.shadow.net.dv8tion.jda.api.components.tree.ComponentTree;
import com.shadow.net.dv8tion.jda.api.entities.MessageEmbed;
import com.shadow.net.dv8tion.jda.api.interactions.callbacks.IDeferrableCallback;
import com.shadow.net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import com.shadow.net.dv8tion.jda.api.utils.FileUpload;
import com.shadow.net.dv8tion.jda.api.utils.messages.MessageCreateData;
import com.shadow.net.dv8tion.jda.api.utils.messages.MessagePollData;
import com.shadow.net.dv8tion.jda.internal.requests.restaction.interactions.ReplyCallbackActionImpl;
import com.shadow.net.dv8tion.jda.internal.utils.Checks;
import com.shadow.net.dv8tion.jda.internal.utils.Helpers;
import java.util.Collection;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public interface IReplyCallback
extends IDeferrableCallback {
    @Nonnull
    @CheckReturnValue
    public ReplyCallbackAction deferReply();

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction deferReply(boolean ephemeral) {
        return this.deferReply().setEphemeral(ephemeral);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction reply(@Nonnull MessageCreateData message) {
        Checks.notNull(message, "Message");
        ReplyCallbackActionImpl action = (ReplyCallbackActionImpl)this.deferReply();
        return (ReplyCallbackAction)action.applyData(message);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyPoll(@Nonnull MessagePollData poll) {
        Checks.notNull(poll, "Message Poll");
        return (ReplyCallbackAction)this.deferReply().setPoll(poll);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction reply(@Nonnull String content) {
        Checks.notNull(content, "Content");
        return (ReplyCallbackAction)this.deferReply().setContent(content);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyEmbeds(@Nonnull Collection<? extends MessageEmbed> embeds) {
        return (ReplyCallbackAction)this.deferReply().addEmbeds(embeds);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyEmbeds(@Nonnull MessageEmbed embed, MessageEmbed ... embeds) {
        Checks.notNull(embed, "MessageEmbed");
        Checks.noneNull(embeds, "MessageEmbed");
        return (ReplyCallbackAction)((ReplyCallbackAction)this.deferReply().addEmbeds(embed)).addEmbeds(embeds);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyComponents(@Nonnull Collection<? extends MessageTopLevelComponent> components) {
        return (ReplyCallbackAction)this.deferReply().setComponents(components);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyComponents(@Nonnull MessageTopLevelComponent component, MessageTopLevelComponent ... other) {
        Checks.notNull(component, "MessageTopLevelComponent");
        Checks.noneNull(other, "MessageTopLevelComponents");
        return this.replyComponents(Helpers.mergeVararg(component, other));
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyComponents(@Nonnull ComponentTree<? extends MessageTopLevelComponent> tree) {
        Checks.notNull(tree, "ComponentTree");
        return this.replyComponents(tree.getComponents());
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyFormat(@Nonnull String format, Object ... args2) {
        Checks.notNull(format, "Format String");
        return this.reply(String.format(format, args2));
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyFiles(@Nonnull Collection<? extends FileUpload> files) {
        Checks.notEmpty(files, "File Collection");
        return (ReplyCallbackAction)this.deferReply().setFiles(files);
    }

    @Nonnull
    @CheckReturnValue
    default public ReplyCallbackAction replyFiles(FileUpload ... files) {
        Checks.notEmpty(files, "File Collection");
        Checks.noneNull(files, "FileUpload");
        return (ReplyCallbackAction)this.deferReply().setFiles(files);
    }
}

