/*
 * Decompiled with CFR 0.152.
 */
package com.shadow.net.dv8tion.jda.internal.components.selections;

import com.shadow.net.dv8tion.jda.api.components.Component;
import com.shadow.net.dv8tion.jda.api.components.label.LabelChildComponentUnion;
import com.shadow.net.dv8tion.jda.api.components.selections.SelectOption;
import com.shadow.net.dv8tion.jda.api.components.selections.StringSelectMenu;
import com.shadow.net.dv8tion.jda.api.utils.data.DataArray;
import com.shadow.net.dv8tion.jda.api.utils.data.DataObject;
import com.shadow.net.dv8tion.jda.internal.components.selections.SelectMenuImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class StringSelectMenuImpl
extends SelectMenuImpl
implements StringSelectMenu,
LabelChildComponentUnion {
    private final List<SelectOption> options;

    public StringSelectMenuImpl(DataObject data) {
        super(data);
        this.options = StringSelectMenuImpl.parseOptions(data.getArray("options"));
    }

    public StringSelectMenuImpl(String id, int uniqueId, String placeholder, int minValues, int maxValues, boolean disabled, List<SelectOption> options, Boolean required) {
        super(id, uniqueId, placeholder, minValues, maxValues, disabled, required);
        this.options = options;
    }

    private static List<SelectOption> parseOptions(DataArray array) {
        ArrayList<SelectOption> options = new ArrayList<SelectOption>(array.length());
        array.stream(DataArray::getObject).map(SelectOption::fromData).forEach(options::add);
        return options;
    }

    @Override
    @Nonnull
    public Component.Type getType() {
        return Component.Type.STRING_SELECT;
    }

    @Override
    @Nonnull
    public StringSelectMenuImpl withUniqueId(int uniqueId) {
        return (StringSelectMenuImpl)((StringSelectMenu.Builder)this.createCopy().setUniqueId(uniqueId)).build();
    }

    @Override
    @Nonnull
    public List<SelectOption> getOptions() {
        return Collections.unmodifiableList(this.options);
    }

    @Override
    @Nonnull
    public DataObject toData() {
        return super.toData().put("type", Component.Type.STRING_SELECT.getKey()).put("options", DataArray.fromCollection(this.options));
    }

    public int hashCode() {
        return Objects.hash(this.id, this.placeholder, this.minValues, this.maxValues, this.disabled, this.options);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StringSelectMenu)) {
            return false;
        }
        StringSelectMenu other = (StringSelectMenu)obj;
        return Objects.equals(this.id, other.getCustomId()) && Objects.equals(this.placeholder, other.getPlaceholder()) && this.minValues == other.getMinValues() && this.maxValues == other.getMaxValues() && this.disabled == other.isDisabled() && Objects.equals(this.options, other.getOptions()) && Objects.equals(this.required, other.isRequired());
    }
}

