/*
 * Decompiled with CFR 0.152.
 */
package com.shadow.net.dv8tion.jda.internal.components.utils;

import com.shadow.net.dv8tion.jda.api.components.Component;
import com.shadow.net.dv8tion.jda.api.components.IComponentUnion;
import com.shadow.net.dv8tion.jda.api.components.ResolvedMedia;
import com.shadow.net.dv8tion.jda.api.components.actionrow.ActionRow;
import com.shadow.net.dv8tion.jda.api.components.replacer.ComponentReplacer;
import com.shadow.net.dv8tion.jda.api.components.replacer.IReplaceable;
import com.shadow.net.dv8tion.jda.api.components.textdisplay.TextDisplay;
import com.shadow.net.dv8tion.jda.api.components.utils.ComponentIterator;
import com.shadow.net.dv8tion.jda.api.utils.FileUpload;
import com.shadow.net.dv8tion.jda.internal.utils.Checks;
import com.shadow.net.dv8tion.jda.internal.utils.Helpers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ComponentsUtil {
    public static <T extends IComponentUnion> T safeUnionCast(String componentCategory, Component component, Class<T> toUnionClass) {
        if (toUnionClass.isInstance(component)) {
            IComponentUnion union = (IComponentUnion)toUnionClass.cast(component);
            Checks.check(!union.isUnknownComponent(), "Cannot provide UnknownComponent");
            return (T)union;
        }
        String cleanedClassName = component.getClass().getSimpleName().replace("Impl", "");
        throw new IllegalArgumentException(Helpers.format("Cannot convert " + componentCategory + " of type %s to %s!", cleanedClassName, toUnionClass.getSimpleName()));
    }

    public static <T extends Component> T safeUnionCastWithUnknownType(String componentCategory, Component component, Class<T> toUnionClass) {
        if (toUnionClass.isInstance(component)) {
            return (T)((Component)toUnionClass.cast(component));
        }
        String cleanedClassName = component.getClass().getSimpleName().replace("Impl", "");
        throw new IllegalArgumentException(Helpers.format("Cannot convert " + componentCategory + " of type %s to %s!", cleanedClassName, toUnionClass.getSimpleName()));
    }

    public static <TUnion extends IComponentUnion> List<TUnion> membersToUnion(Collection<? extends Component> members, Class<TUnion> clazz) {
        return members.stream().map(c -> ComponentsUtil.safeUnionCast("component", c, clazz)).collect(Collectors.toList());
    }

    public static <T extends Component> List<T> membersToUnionWithUnknownType(Collection<? extends Component> members, Class<T> clazz) {
        return members.stream().map(c -> ComponentsUtil.safeUnionCastWithUnknownType("component", c, clazz)).collect(Collectors.toList());
    }

    public static <R, E extends Component> R doReplace(Class<? extends Component> expectedChildrenType, Iterable<E> children, ComponentReplacer replacer, Function<List<E>, R> finisher) {
        ArrayList<Component> newComponents = new ArrayList<Component>();
        for (Component component : children) {
            Component newComponent = replacer.apply(component);
            if (newComponent == null) continue;
            if (newComponent != component) {
                Checks.checkComponentType(expectedChildrenType, component, newComponent);
            } else if (component instanceof IReplaceable) {
                newComponent = ((IReplaceable)((Object)component)).replace(replacer);
                Checks.checkComponentType(expectedChildrenType, component, newComponent);
            }
            newComponents.add(newComponent);
        }
        return finisher.apply(newComponents);
    }

    public static long getComponentTreeSize(@Nonnull Collection<? extends Component> tree) {
        return ComponentIterator.createStream(tree).count();
    }

    @Nonnull
    public static List<? extends Component> getIllegalV1Components(@Nonnull Collection<? extends Component> components) {
        return components.stream().filter(c -> !(c instanceof ActionRow)).collect(Collectors.toList());
    }

    public static boolean hasIllegalV1Components(@Nonnull Collection<? extends Component> components) {
        return !ComponentsUtil.getIllegalV1Components(components).isEmpty();
    }

    public static long getComponentTreeTextContentLength(@Nonnull Collection<? extends Component> components) {
        return ComponentIterator.createStream(components).mapToInt(c -> {
            if (c instanceof TextDisplay) {
                return ((TextDisplay)c).getContent().length();
            }
            return 0;
        }).sum();
    }

    public static Stream<FileUpload> getFilesFromMedia(@Nullable ResolvedMedia media) {
        if (media != null) {
            String fileName = Helpers.getLastPathSegment(media.getUrl());
            return Stream.of(media.getProxy().downloadAsFileUpload(fileName));
        }
        return Stream.empty();
    }
}

