/*
 * Decompiled with CFR 0.152.
 */
package com.shadow.net.dv8tion.jda.internal.handle;

import com.shadow.net.dv8tion.jda.api.JDA;
import com.shadow.net.dv8tion.jda.api.entities.Guild;
import com.shadow.net.dv8tion.jda.api.entities.Member;
import com.shadow.net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import com.shadow.net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import com.shadow.net.dv8tion.jda.api.entities.guild.SecurityIncidentActions;
import com.shadow.net.dv8tion.jda.api.entities.guild.SecurityIncidentDetections;
import com.shadow.net.dv8tion.jda.api.entities.guild.SystemChannelFlag;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateAfkChannelEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateAfkTimeoutEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateBannerEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateBoostCountEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateBoostTierEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateCommunityUpdatesChannelEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateDescriptionEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateExplicitContentLevelEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateFeaturesEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateIconEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateLocaleEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateMFALevelEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateMaxMembersEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateMaxPresencesEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateNSFWLevelEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateNameEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateNotificationLevelEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateOwnerEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateRulesChannelEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateSafetyAlertsChannelEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateSecurityIncidentActionsEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateSecurityIncidentDetectionsEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateSplashEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateSystemChannelEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateSystemChannelFlagsEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateVanityCodeEvent;
import com.shadow.net.dv8tion.jda.api.events.guild.update.GuildUpdateVerificationLevelEvent;
import com.shadow.net.dv8tion.jda.api.interactions.DiscordLocale;
import com.shadow.net.dv8tion.jda.api.utils.data.DataArray;
import com.shadow.net.dv8tion.jda.api.utils.data.DataObject;
import com.shadow.net.dv8tion.jda.internal.JDAImpl;
import com.shadow.net.dv8tion.jda.internal.entities.GuildImpl;
import com.shadow.net.dv8tion.jda.internal.handle.EventCache;
import com.shadow.net.dv8tion.jda.internal.handle.SocketHandler;
import com.shadow.net.dv8tion.jda.internal.requests.WebSocketClient;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class GuildUpdateHandler
extends SocketHandler {
    public GuildUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(DataObject content) {
        Set<String> features;
        long id = content.getLong("id");
        if (this.getJDA().getGuildSetupController().isLocked(id)) {
            return id;
        }
        GuildImpl guild = (GuildImpl)this.getJDA().getGuildById(id);
        if (guild == null) {
            EventCache.LOG.debug("Caching GUILD_UPDATE for guild with id: {}", (Object)id);
            this.getJDA().getEventCache().cache(EventCache.Type.GUILD, id, this.responseNumber, this.allContent, this::handle);
            return null;
        }
        int maxMembers = content.getInt("max_members", 0);
        int maxPresences = content.getInt("max_presences", 5000);
        if (guild.getMaxMembers() == 0) {
            guild.setMaxPresences(maxPresences);
            guild.setMaxMembers(maxMembers);
        }
        long ownerId = content.getLong("owner_id");
        int boostCount = content.getInt("premium_subscription_count", 0);
        int boostTier = content.getInt("premium_tier", 0);
        String description = content.getString("description", null);
        String vanityCode = content.getString("vanity_url_code", null);
        String bannerId = content.getString("banner", null);
        String name = content.getString("name");
        String iconId = content.getString("icon", null);
        String splashId = content.getString("splash", null);
        SecurityIncidentActions securityIncidentActions = content.optObject("incidents_data").map(this.api.getEntityBuilder()::createSecurityIncidentsActions).orElse(SecurityIncidentActions.disabled());
        SecurityIncidentDetections securityIncidentDetections = content.optObject("incidents_data").map(this.api.getEntityBuilder()::createSecurityIncidentsDetections).orElse(SecurityIncidentDetections.EMPTY);
        Guild.VerificationLevel verificationLevel = Guild.VerificationLevel.fromKey(content.getInt("verification_level"));
        Guild.NotificationLevel notificationLevel = Guild.NotificationLevel.fromKey(content.getInt("default_message_notifications"));
        Guild.MFALevel mfaLevel = Guild.MFALevel.fromKey(content.getInt("mfa_level"));
        Guild.NSFWLevel nsfwLevel = Guild.NSFWLevel.fromKey(content.getInt("nsfw_level", -1));
        Guild.ExplicitContentLevel explicitContentLevel = Guild.ExplicitContentLevel.fromKey(content.getInt("explicit_content_filter"));
        Guild.Timeout afkTimeout = Guild.Timeout.fromKey(content.getInt("afk_timeout"));
        DiscordLocale locale = DiscordLocale.from(content.getString("preferred_locale", "en-US"));
        VoiceChannel afkChannel = content.isNull("afk_channel_id") ? null : guild.getChannelById(VoiceChannel.class, content.getLong("afk_channel_id"));
        TextChannel systemChannel = content.isNull("system_channel_id") ? null : guild.getChannelById(TextChannel.class, content.getLong("system_channel_id"));
        TextChannel rulesChannel = content.isNull("rules_channel_id") ? null : guild.getChannelById(TextChannel.class, content.getLong("rules_channel_id"));
        TextChannel communityUpdatesChannel = content.isNull("public_updates_channel_id") ? null : guild.getChannelById(TextChannel.class, content.getLong("public_updates_channel_id"));
        TextChannel safetyAlertsChannel = content.isNull("safety_alerts_channel_id") ? null : guild.getChannelById(TextChannel.class, content.getLong("safety_alerts_channel_id"));
        int systemChannelFlagBitmask = content.getInt("system_channel_flags", 0);
        if (!content.isNull("features")) {
            DataArray featureArr = content.getArray("features");
            features = featureArr.stream(DataArray::getString).map(String::intern).collect(Collectors.toSet());
        } else {
            features = Collections.emptySet();
        }
        if (ownerId != guild.getOwnerIdLong()) {
            long oldOwnerId = guild.getOwnerIdLong();
            Member oldOwner = guild.getOwner();
            Member newOwner = (Member)guild.getMembersView().get(ownerId);
            if (newOwner == null) {
                WebSocketClient.LOG.debug("Received {} with owner not in cache. UserId: {} GuildId: {}", new Object[]{this.allContent.get("t"), ownerId, id});
            }
            guild.setOwner(newOwner);
            guild.setOwnerId(ownerId);
            this.getJDA().handleEvent(new GuildUpdateOwnerEvent((JDA)this.getJDA(), this.responseNumber, (Guild)guild, oldOwner, oldOwnerId, ownerId));
        }
        if (systemChannelFlagBitmask != guild.getSystemChannelFlagsRaw()) {
            Set<SystemChannelFlag> oldSystemChannelFlags = guild.getSystemChannelFlags();
            Set<SystemChannelFlag> systemChannelFlags = Collections.unmodifiableSet(SystemChannelFlag.getFlags(systemChannelFlagBitmask));
            guild.setSystemChannelFlags(systemChannelFlagBitmask);
            this.getJDA().handleEvent(new GuildUpdateSystemChannelFlagsEvent(this.getJDA(), this.responseNumber, guild, oldSystemChannelFlags, systemChannelFlags));
        }
        if (!Objects.equals(description, guild.getDescription())) {
            String oldDescription = guild.getDescription();
            guild.setDescription(description);
            this.getJDA().handleEvent(new GuildUpdateDescriptionEvent(this.getJDA(), this.responseNumber, guild, oldDescription));
        }
        if (!Objects.equals(bannerId, guild.getBannerId())) {
            String oldBanner = guild.getBannerId();
            guild.setBannerId(bannerId);
            this.getJDA().handleEvent(new GuildUpdateBannerEvent(this.getJDA(), this.responseNumber, guild, oldBanner));
        }
        if (!Objects.equals(vanityCode, guild.getVanityCode())) {
            String oldCode = guild.getVanityCode();
            guild.setVanityCode(vanityCode);
            this.getJDA().handleEvent(new GuildUpdateVanityCodeEvent(this.getJDA(), this.responseNumber, guild, oldCode));
        }
        if (maxMembers != guild.getMaxMembers()) {
            int oldMax = guild.getMaxMembers();
            guild.setMaxMembers(maxMembers);
            this.getJDA().handleEvent(new GuildUpdateMaxMembersEvent(this.getJDA(), this.responseNumber, guild, oldMax));
        }
        if (maxPresences != guild.getMaxPresences()) {
            int oldMax = guild.getMaxPresences();
            guild.setMaxPresences(maxPresences);
            this.getJDA().handleEvent(new GuildUpdateMaxPresencesEvent(this.getJDA(), this.responseNumber, guild, oldMax));
        }
        if (boostCount != guild.getBoostCount()) {
            int oldCount = guild.getBoostCount();
            guild.setBoostCount(boostCount);
            this.getJDA().handleEvent(new GuildUpdateBoostCountEvent(this.getJDA(), this.responseNumber, guild, oldCount));
        }
        if (Guild.BoostTier.fromKey(boostTier) != guild.getBoostTier()) {
            Guild.BoostTier oldTier = guild.getBoostTier();
            guild.setBoostTier(boostTier);
            this.getJDA().handleEvent(new GuildUpdateBoostTierEvent(this.getJDA(), this.responseNumber, guild, oldTier));
        }
        if (!Objects.equals(name, guild.getName())) {
            String oldName = guild.getName();
            guild.setName(name);
            this.getJDA().handleEvent(new GuildUpdateNameEvent(this.getJDA(), this.responseNumber, guild, oldName));
        }
        if (!Objects.equals(iconId, guild.getIconId())) {
            String oldIconId = guild.getIconId();
            guild.setIconId(iconId);
            this.getJDA().handleEvent(new GuildUpdateIconEvent(this.getJDA(), this.responseNumber, guild, oldIconId));
        }
        if (!features.equals(guild.getFeatures())) {
            Set<String> oldFeatures = guild.getFeatures();
            guild.setFeatures(features);
            this.getJDA().handleEvent(new GuildUpdateFeaturesEvent(this.getJDA(), this.responseNumber, guild, oldFeatures));
        }
        if (!Objects.equals(splashId, guild.getSplashId())) {
            String oldSplashId = guild.getSplashId();
            guild.setSplashId(splashId);
            this.getJDA().handleEvent(new GuildUpdateSplashEvent(this.getJDA(), this.responseNumber, guild, oldSplashId));
        }
        if (!Objects.equals((Object)verificationLevel, (Object)guild.getVerificationLevel())) {
            Guild.VerificationLevel oldVerificationLevel = guild.getVerificationLevel();
            guild.setVerificationLevel(verificationLevel);
            this.getJDA().handleEvent(new GuildUpdateVerificationLevelEvent(this.getJDA(), this.responseNumber, guild, oldVerificationLevel));
        }
        if (!Objects.equals((Object)notificationLevel, (Object)guild.getDefaultNotificationLevel())) {
            Guild.NotificationLevel oldNotificationLevel = guild.getDefaultNotificationLevel();
            guild.setDefaultNotificationLevel(notificationLevel);
            this.getJDA().handleEvent(new GuildUpdateNotificationLevelEvent(this.getJDA(), this.responseNumber, guild, oldNotificationLevel));
        }
        if (!Objects.equals((Object)mfaLevel, (Object)guild.getRequiredMFALevel())) {
            Guild.MFALevel oldMfaLevel = guild.getRequiredMFALevel();
            guild.setRequiredMFALevel(mfaLevel);
            this.getJDA().handleEvent(new GuildUpdateMFALevelEvent(this.getJDA(), this.responseNumber, guild, oldMfaLevel));
        }
        if (!Objects.equals((Object)explicitContentLevel, (Object)guild.getExplicitContentLevel())) {
            Guild.ExplicitContentLevel oldExplicitContentLevel = guild.getExplicitContentLevel();
            guild.setExplicitContentLevel(explicitContentLevel);
            this.getJDA().handleEvent(new GuildUpdateExplicitContentLevelEvent(this.getJDA(), this.responseNumber, guild, oldExplicitContentLevel));
        }
        if (!Objects.equals((Object)afkTimeout, (Object)guild.getAfkTimeout())) {
            Guild.Timeout oldAfkTimeout = guild.getAfkTimeout();
            guild.setAfkTimeout(afkTimeout);
            this.getJDA().handleEvent(new GuildUpdateAfkTimeoutEvent(this.getJDA(), this.responseNumber, guild, oldAfkTimeout));
        }
        if (!Objects.equals((Object)locale, (Object)guild.getLocale())) {
            DiscordLocale oldLocale = guild.getLocale();
            guild.setLocale(locale);
            this.getJDA().handleEvent(new GuildUpdateLocaleEvent(this.getJDA(), this.responseNumber, guild, oldLocale));
        }
        if (!Objects.equals(afkChannel, guild.getAfkChannel())) {
            VoiceChannel oldAfkChannel = guild.getAfkChannel();
            guild.setAfkChannel(afkChannel);
            this.getJDA().handleEvent(new GuildUpdateAfkChannelEvent(this.getJDA(), this.responseNumber, guild, oldAfkChannel));
        }
        if (!Objects.equals(systemChannel, guild.getSystemChannel())) {
            TextChannel oldSystemChannel = guild.getSystemChannel();
            guild.setSystemChannel(systemChannel);
            this.getJDA().handleEvent(new GuildUpdateSystemChannelEvent(this.getJDA(), this.responseNumber, guild, oldSystemChannel));
        }
        if (!Objects.equals(rulesChannel, guild.getRulesChannel())) {
            TextChannel oldRulesChannel = guild.getRulesChannel();
            guild.setRulesChannel(rulesChannel);
            this.getJDA().handleEvent(new GuildUpdateRulesChannelEvent(this.getJDA(), this.responseNumber, guild, oldRulesChannel));
        }
        if (!Objects.equals(communityUpdatesChannel, guild.getCommunityUpdatesChannel())) {
            TextChannel oldCommunityUpdatesChannel = guild.getCommunityUpdatesChannel();
            guild.setCommunityUpdatesChannel(communityUpdatesChannel);
            this.getJDA().handleEvent(new GuildUpdateCommunityUpdatesChannelEvent(this.getJDA(), this.responseNumber, guild, oldCommunityUpdatesChannel));
        }
        if (!Objects.equals(safetyAlertsChannel, guild.getSafetyAlertsChannel())) {
            TextChannel oldSafetyAlertsChannel = guild.getSafetyAlertsChannel();
            guild.setSafetyAlertsChannel(safetyAlertsChannel);
            this.getJDA().handleEvent(new GuildUpdateSafetyAlertsChannelEvent(this.getJDA(), this.responseNumber, guild, oldSafetyAlertsChannel));
        }
        if (!Objects.equals(securityIncidentActions, guild.getSecurityIncidentActions())) {
            SecurityIncidentActions oldIncidentActions = guild.getSecurityIncidentActions();
            guild.setSecurityIncidentActions(securityIncidentActions);
            this.api.handleEvent(new GuildUpdateSecurityIncidentActionsEvent(this.getJDA(), this.responseNumber, guild, oldIncidentActions));
        }
        if (!Objects.equals(securityIncidentDetections, guild.getSecurityIncidentDetections())) {
            SecurityIncidentDetections oldIncidentDetections = guild.getSecurityIncidentDetections();
            guild.setSecurityIncidentDetections(securityIncidentDetections);
            this.api.handleEvent(new GuildUpdateSecurityIncidentDetectionsEvent(this.getJDA(), this.responseNumber, guild, oldIncidentDetections));
        }
        if (content.hasKey("nsfw_level") && nsfwLevel != guild.getNSFWLevel()) {
            Guild.NSFWLevel oldNSFWLevel = guild.getNSFWLevel();
            guild.setNSFWLevel(nsfwLevel);
            this.getJDA().handleEvent(new GuildUpdateNSFWLevelEvent(this.getJDA(), this.responseNumber, guild, oldNSFWLevel));
        }
        return null;
    }
}

