/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod;

import java.util.HashMap;
import net.minecraft.ChatFormatting;
import org.jetbrains.annotations.Nullable;

public class ColorUtils {
    public static final HashMap<String, Integer> colorNameToInt = new HashMap<String, Integer>(){
        {
            this.put("black", ChatFormatting.BLACK.getColor());
            this.put("darkblue", ChatFormatting.DARK_BLUE.getColor());
            this.put("darkgreen", ChatFormatting.DARK_GREEN.getColor());
            this.put("darkaqua", ChatFormatting.DARK_AQUA.getColor());
            this.put("darkred", ChatFormatting.DARK_RED.getColor());
            this.put("darkpurple", ChatFormatting.DARK_PURPLE.getColor());
            this.put("gold", ChatFormatting.GOLD.getColor());
            this.put("grey", ChatFormatting.GRAY.getColor());
            this.put("darkgrey", ChatFormatting.DARK_GRAY.getColor());
            this.put("blue", ChatFormatting.BLUE.getColor());
            this.put("green", ChatFormatting.GREEN.getColor());
            this.put("aqua", ChatFormatting.AQUA.getColor());
            this.put("red", ChatFormatting.RED.getColor());
            this.put("lightpurple", ChatFormatting.LIGHT_PURPLE.getColor());
            this.put("yellow", ChatFormatting.YELLOW.getColor());
            this.put("white", ChatFormatting.WHITE.getColor());
        }
    };

    @Nullable
    public static Integer parseColor(String colorNameOrHex) {
        String colorNameOrHexLower = colorNameOrHex.toLowerCase();
        if (colorNameToInt.containsKey(colorNameOrHexLower)) {
            return colorNameToInt.get(colorNameOrHex);
        }
        try {
            return Integer.parseInt(colorNameOrHexLower.substring(1), 16);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    public static String getHexColor(@Nullable java.awt.Color color) {
        if (color == null) {
            return "#ffffff";
        }
        return "#" + Integer.toHexString(color.getRGB()).substring(2);
    }

    public static String getHexColor(int color) {
        return ColorUtils.getHexColor(new java.awt.Color(color));
    }

    public static class Color {
        public static final int CHANNEL_MENTION_COLOR = 6911177;
        public static int CHAT_LINK_COLOR = 47103;
    }
}

