/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod;

import com.denisnumb.discord_chat_mod.LocaleProvider;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.damagesource.FallLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class DeathMessageUtils {
    private static final Style INTENTIONAL_GAME_DESIGN_STYLE = Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://bugs.mojang.com/browse/MCPE-28723")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"MCPE-28723")));
    public static final String DEATH_CAUSE_REPLACEMENT_TAG = "{death.cause}";
    public static final String DIED_ENTITY_REPLACEMENT_TAG = "{died.entity}";
    public static final String KILLER_ENTITY_REPLACEMENT_TAG = "{second.entity}";
    public static final String ITEM_REPLACEMENT_TAG = "{item}";

    public static DeathMessageComponents getDeathMessageComponents(List<CombatEntry> entries, LivingEntity diedEntity) {
        if (entries.isEmpty()) {
            return new DeathMessageComponents(DeathMessageUtils.getLocalizedDisplayName((Entity)diedEntity), (Component)Component.literal((String)LocaleProvider.getTranslate("death.attack.generic")), null, null);
        }
        DamageSource damageSource = entries.getLast().source();
        CombatEntry mostSignificantFall = DeathMessageUtils.getMostSignificantFall(entries);
        DeathMessageType deathMessageType = damageSource.type().deathMessageType();
        if (deathMessageType == DeathMessageType.FALL_VARIANTS && mostSignificantFall != null) {
            return DeathMessageUtils.getFallMessage(mostSignificantFall, damageSource.getEntity(), diedEntity);
        }
        if (deathMessageType == DeathMessageType.INTENTIONAL_GAME_DESIGN) {
            String base = "death.attack." + damageSource.getMsgId();
            MutableComponent intentionalGameDesign = ComponentUtils.wrapInSquareBrackets((Component)Component.literal((String)LocaleProvider.getTranslate(base + ".link"))).withStyle(INTENTIONAL_GAME_DESIGN_STYLE);
            return new DeathMessageComponents(DeathMessageUtils.getLocalizedDisplayName((Entity)diedEntity), (Component)Component.literal((String)LocaleProvider.getTranslate(base + "message")), (Component)intentionalGameDesign, null);
        }
        return DeathMessageUtils.getLocalizedDeathMessage(damageSource, diedEntity);
    }

    private static DeathMessageComponents getFallMessage(CombatEntry combatEntry, @Nullable Entity killerEntity, LivingEntity diedEntity) {
        DamageSource damageSource = combatEntry.source();
        if (!damageSource.is(DamageTypeTags.IS_FALL) && !damageSource.is(DamageTypeTags.ALWAYS_MOST_SIGNIFICANT_FALL)) {
            Component killerEntityDisplayName = DeathMessageUtils.getLocalizedDisplayName(killerEntity);
            Entity fallCauseEntity = damageSource.getEntity();
            Component fallCauseEntityDisplayName = DeathMessageUtils.getLocalizedDisplayName(fallCauseEntity);
            if (fallCauseEntityDisplayName != null && !fallCauseEntityDisplayName.equals((Object)killerEntityDisplayName)) {
                return DeathMessageUtils.getMessageForAssistedFall(fallCauseEntity, fallCauseEntityDisplayName, "death.fell.assist.item", "death.fell.assist", diedEntity);
            }
            return killerEntityDisplayName != null ? DeathMessageUtils.getMessageForAssistedFall(killerEntity, killerEntityDisplayName, "death.fell.finish.item", "death.fell.finish", diedEntity) : new DeathMessageComponents(DeathMessageUtils.getLocalizedDisplayName((Entity)diedEntity), (Component)Component.literal((String)LocaleProvider.getTranslate("death.fell.killer")), null, null);
        }
        FallLocation fallLocation = Objects.requireNonNullElse(combatEntry.fallLocation(), FallLocation.GENERIC);
        return new DeathMessageComponents(DeathMessageUtils.getLocalizedDisplayName((Entity)diedEntity), (Component)Component.literal((String)LocaleProvider.getTranslate(fallLocation.languageKey())), null, null);
    }

    private static DeathMessageComponents getLocalizedDeathMessage(DamageSource source2, LivingEntity diedEntity) {
        Component diedEntityName = DeathMessageUtils.getLocalizedDisplayName((Entity)diedEntity);
        String attackBase = "death.attack." + source2.type().msgId();
        if (source2.getEntity() == null && source2.getDirectEntity() == null) {
            LivingEntity playerKiller = diedEntity.getKillCredit();
            String byPlayer = attackBase + ".player";
            return playerKiller != null ? new DeathMessageComponents(diedEntityName, (Component)Component.literal((String)LocaleProvider.getTranslate(byPlayer)), DeathMessageUtils.getLocalizedDisplayName((Entity)playerKiller), null) : new DeathMessageComponents(diedEntityName, (Component)Component.literal((String)LocaleProvider.getTranslate(attackBase)), null, null);
        }
        Component killerEntityName = source2.getEntity() == null ? DeathMessageUtils.getLocalizedDisplayName(source2.getDirectEntity()) : DeathMessageUtils.getLocalizedDisplayName(source2.getEntity());
        Entity entity = source2.getEntity();
        ItemStack item = entity instanceof LivingEntity ? ((LivingEntity)entity).getMainHandItem() : ItemStack.EMPTY;
        return !item.isEmpty() && item.has(DataComponents.CUSTOM_NAME) ? new DeathMessageComponents(diedEntityName, (Component)Component.literal((String)LocaleProvider.getTranslate(attackBase + ".item")), killerEntityName, item.getDisplayName()) : new DeathMessageComponents(diedEntityName, (Component)Component.literal((String)LocaleProvider.getTranslate(attackBase)), killerEntityName, null);
    }

    private static DeathMessageComponents getMessageForAssistedFall(Entity killer, Component killerDisplayName, String withItem, String withoutItem, LivingEntity diedEntity) {
        ItemStack itemStack;
        if (killer instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)killer;
            itemStack = livingEntity.getMainHandItem();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        ItemStack itemStack2 = itemStack;
        return !itemStack2.isEmpty() && itemStack2.has(DataComponents.CUSTOM_NAME) ? new DeathMessageComponents(DeathMessageUtils.getLocalizedDisplayName((Entity)diedEntity), (Component)Component.literal((String)LocaleProvider.getTranslate(withItem)), killerDisplayName, itemStack2.getDisplayName()) : new DeathMessageComponents(DeathMessageUtils.getLocalizedDisplayName((Entity)diedEntity), (Component)Component.literal((String)LocaleProvider.getTranslate(withoutItem)), killerDisplayName, null);
    }

    @Nullable
    private static Component getLocalizedDisplayName(@Nullable Entity entity) {
        Component component;
        Entity entity2 = entity;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Player.class, TamableAnimal.class}, (Object)entity2, n)) {
                case -1: {
                    component = null;
                    break block5;
                }
                case 0: {
                    Player player = (Player)entity2;
                    component = player.getDisplayName();
                    break block5;
                }
                case 1: {
                    TamableAnimal animal = (TamableAnimal)entity2;
                    if (!animal.hasCustomName()) {
                        n = 2;
                        continue block5;
                    }
                    component = animal.getDisplayName();
                    break block5;
                }
                default: {
                    component = Component.literal((String)LocaleProvider.getTranslate(entity.getType().getDescriptionId()));
                    break block5;
                }
            }
            break;
        }
        return component;
    }

    @Nullable
    private static CombatEntry getMostSignificantFall(List<CombatEntry> entries) {
        CombatEntry combatEntry = null;
        CombatEntry combatEntry2 = null;
        float f = 0.0f;
        float g = 0.0f;
        for (int i = 0; i < entries.size(); ++i) {
            float h;
            CombatEntry combatEntry3 = entries.get(i);
            CombatEntry combatEntry4 = i > 0 ? entries.get(i - 1) : null;
            DamageSource damageSource = combatEntry3.source();
            boolean bl = damageSource.is(DamageTypeTags.ALWAYS_MOST_SIGNIFICANT_FALL);
            float f2 = h = bl ? Float.MAX_VALUE : combatEntry3.fallDistance();
            if ((damageSource.is(DamageTypeTags.IS_FALL) || bl) && h > 0.0f && (combatEntry == null || h > g)) {
                combatEntry = i > 0 ? combatEntry4 : combatEntry3;
                g = h;
            }
            if (combatEntry3.fallLocation() == null || combatEntry2 != null && !(combatEntry3.damage() > f)) continue;
            combatEntry2 = combatEntry3;
            f = combatEntry3.damage();
        }
        if (g > 5.0f && combatEntry != null) {
            return combatEntry;
        }
        if (f > 5.0f && combatEntry2 != null) {
            return combatEntry2;
        }
        return null;
    }

    public record DeathMessageComponents(Component diedEntityName, Component deathCause, @Nullable Component killerEntity, @Nullable Component item) {
        public DeathMessageComponents(Component diedEntityName, Component deathCause, @Nullable Component killerEntity, @Nullable Component item) {
            deathCause = Component.literal((String)deathCause.getString().replace("%1$s", DeathMessageUtils.DIED_ENTITY_REPLACEMENT_TAG).replace("%2$s", DeathMessageUtils.KILLER_ENTITY_REPLACEMENT_TAG).replace("%3$s", DeathMessageUtils.ITEM_REPLACEMENT_TAG));
        }
    }
}

