/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod;

import com.denisnumb.discord_chat_mod.LocaleProvider;
import com.denisnumb.discord_chat_mod.MinecraftUtils;
import com.denisnumb.discord_chat_mod.ServerLogsRetranslator;
import com.denisnumb.discord_chat_mod.chat_style.CustomChatTypeRegistry;
import com.denisnumb.discord_chat_mod.chat_style.Parameters;
import com.denisnumb.discord_chat_mod.commands.ReloadConfigCommand;
import com.denisnumb.discord_chat_mod.commands.set_avatar.AvatarUrlStorage;
import com.denisnumb.discord_chat_mod.config.ConfigProvider;
import com.denisnumb.discord_chat_mod.config.IConfigProvider;
import com.denisnumb.discord_chat_mod.discord.ChannelMembersProvider;
import com.denisnumb.discord_chat_mod.discord.CustomEmojiProvider;
import com.denisnumb.discord_chat_mod.discord.DiscordChannelRegistry;
import com.denisnumb.discord_chat_mod.discord.DiscordEvents;
import com.denisnumb.discord_chat_mod.discord.DiscordUtils;
import com.denisnumb.discord_chat_mod.discord.ServerStatusController;
import com.denisnumb.discord_chat_mod.discord.StickersProvider;
import com.denisnumb.discord_chat_mod.discord.WebhookUtils;
import com.denisnumb.discord_chat_mod.discord.chat_style.DiscordChatStyleProvider;
import com.denisnumb.discord_chat_mod.discord.chat_style.MessageType;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.mojang.logging.LogUtils;
import com.shadow.com.neovisionaries.ws.client.ProxySettings;
import com.shadow.com.neovisionaries.ws.client.WebSocketFactory;
import com.shadow.net.dv8tion.jda.api.JDA;
import com.shadow.net.dv8tion.jda.api.JDABuilder;
import com.shadow.net.dv8tion.jda.api.requests.GatewayIntent;
import com.shadow.net.dv8tion.jda.api.utils.ChunkingFilter;
import com.shadow.net.dv8tion.jda.api.utils.MemberCachePolicy;
import com.shadow.okhttp3.Credentials;
import com.shadow.okhttp3.OkHttpClient;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.time.Duration;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatType;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public final class DiscordChatMod {
    public static final String MOD_ID = "discord_chat_mod";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static JDA jda;
    public static MinecraftServer server;
    private static final DiscordEvents discordEvents;

    public static void onServerStarting(MinecraftServer minecraftServer) {
        server = minecraftServer;
        if (server.isPublished()) {
            DiscordChatMod.initJDA();
        }
        CustomChatTypeRegistry.registerChatTypes((Registry<ChatType>)server.registryAccess().registryOrThrow(Registries.CHAT_TYPE));
    }

    public static void onServerStarted() {
        ServerLogsRetranslator.start();
        DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.SERVER_START, Map.of()).ifPresent(components -> DiscordUtils.sendMessageFromServer(ChannelCategory.SERVER_START_STOP, DiscordChannelRegistry.getAllContexts(), components));
    }

    public static void onServerStopped() {
        DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.SERVER_STOP, Map.of()).ifPresent(components -> DiscordUtils.sendMessageFromServer(ChannelCategory.SERVER_START_STOP, DiscordChannelRegistry.getAllContexts(), components));
        DiscordChatMod.stopJDA();
    }

    public static void onIntegratedServerStarted() {
        Thread t = new Thread(() -> {
            DiscordChatMod.initJDA();
            DiscordChatStyleProvider.getDiscordMessageComponents(MessageType.LOCAL_SERVER_START, Map.of(Parameters.LOCAL_SERVER_STARTED, String.format(LocaleProvider.getTranslate("discord_chat_mod.server.local_started"), server.getPort()), "{server_port}", String.valueOf(server.getPort()))).ifPresent(components -> DiscordUtils.sendMessageFromServer(ChannelCategory.SERVER_START_STOP, DiscordChannelRegistry.getAllContexts(), components));
            StickersProvider.loadClient(StickersProvider.getNameToUrlMap());
            CustomEmojiProvider.loadClient(CustomEmojiProvider.getNameToUrlMap());
            ChannelMembersProvider.CLIENT_MEMBER_CACHE = ChannelMembersProvider.getMemberData(ChannelCategory.PLAYER_CHAT);
        });
        t.setDaemon(true);
        t.start();
    }

    public static boolean isDiscordConnected() {
        return jda != null && jda.getStatus() == JDA.Status.CONNECTED && !ReloadConfigCommand.isReloadingNow;
    }

    public static void initJDA() {
        try {
            IConfigProvider config = ConfigProvider.getConfig();
            WebSocketFactory webSocketFactory = new WebSocketFactory();
            if (!config.proxyHostname().isEmpty()) {
                ProxySettings settings = webSocketFactory.getProxySettings();
                settings.setHost(config.proxyHostname()).setPort(config.proxyPort());
                if (!config.proxyUser().isEmpty()) {
                    settings.setCredentials(config.proxyUser(), config.proxyPassword());
                }
            }
            OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
            if (!config.proxyHostname().isEmpty()) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(config.proxyHostname(), config.proxyPort()));
                httpClientBuilder.proxy(proxy);
                if (!config.proxyUser().isEmpty()) {
                    httpClientBuilder.proxyAuthenticator((proxy1, url) -> {
                        String credential = Credentials.basic(config.proxyUser(), config.proxyPassword());
                        return url.request().newBuilder().header("Proxy-Authorization", credential).build();
                    });
                }
            }
            jda = JDABuilder.create(config.discordBotToken(), GatewayIntent.MESSAGE_CONTENT, GatewayIntent.GUILD_MEMBERS, GatewayIntent.GUILD_PRESENCES, GatewayIntent.GUILD_MESSAGES, GatewayIntent.GUILD_EXPRESSIONS).setChunkingFilter(ChunkingFilter.ALL).setMemberCachePolicy(MemberCachePolicy.ALL).addEventListeners(discordEvents).setHttpClientBuilder(httpClientBuilder).setWebsocketFactory(webSocketFactory).build();
            jda.awaitReady();
            WebhookUtils.initWebhookSendExecutor();
            DiscordUtils.initDiscordSendExecutor();
            DiscordChannelRegistry.initDiscordChannels(config.discordGuildConfigs());
            ServerStatusController.initServerStatusController();
            AvatarUrlStorage.load(server);
            if (!DiscordChannelRegistry.isChannelCategoryDisabled(DiscordChannelRegistry.serverLogsChannel)) {
                ServerLogsRetranslator.init(config.serverLogsToDiscordLoggingLevel());
            }
            LOGGER.info("Discord connected");
        }
        catch (Exception e) {
            MinecraftUtils.logErrorToServer(String.format("DiscordConnectError: %s", e.getMessage()));
            e.printStackTrace();
            DiscordChatMod.stopJDA();
        }
    }

    public static void stopJDA() {
        if (jda != null) {
            ServerStatusController.updateServerStatusMessageToUnavailable();
            ServerLogsRetranslator.stop();
            WebhookUtils.stopWebhookSendExecutor();
            DiscordUtils.stopDiscordSendExecutor();
            AvatarUrlStorage.unload();
            LOGGER.info("Disconnecting from discord...");
            try {
                jda.removeEventListener(discordEvents);
                jda.awaitShutdown(Duration.ofMillis(5000L));
                jda.cancelRequests();
                jda.shutdownNow();
                if (jda.getHttpClient() != null) {
                    jda.getHttpClient().dispatcher().executorService().shutdownNow();
                    jda.getHttpClient().connectionPool().evictAll();
                }
                jda.getGatewayPool().shutdownNow();
                jda.getCallbackPool().shutdownNow();
                jda.getRateLimitPool().shutdownNow();
            }
            catch (Exception exception) {
                // empty catch block
            }
            jda = null;
            LOGGER.info("Discord disconnected");
        }
    }

    static {
        discordEvents = new DiscordEvents();
    }
}

