/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod;

import com.denisnumb.discord_chat_mod.LocaleProvider;
import com.denisnumb.discord_chat_mod.config.ConfigProvider;
import com.denisnumb.discord_chat_mod.network.emoji.DiscordEmojisTransceiver;
import com.denisnumb.discord_chat_mod.network.mentions.DiscordMentionsTransceiver;
import com.denisnumb.discord_chat_mod.network.sticker.DiscordStickersTransceiver;
import com.shadow.com.vdurmont.emoji.EmojiParser;
import java.io.File;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;

public class MinecraftClientEvents {
    public static Component handleScreenshot(File screenshotFile) {
        MutableComponent screenshotName = Component.literal((String)screenshotFile.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, screenshotFile.getAbsolutePath())));
        MutableComponent clickToSendComponent = Component.literal((String)(" " + LocaleProvider.getTranslateClient("discord_chat_mod.command.send_screenshot.click_to_send"))).withStyle(style -> style.withColor(ChatFormatting.GREEN.getColor().intValue()).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "send_screenshot " + screenshotFile.getAbsolutePath())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)LocaleProvider.getTranslateClient("discord_chat_mod.command.send_screenshot.click_to_send.hint")))));
        return Component.literal((String)LocaleProvider.getTranslateClient("screenshot.success").replace("%s", "")).append((Component)screenshotName).append((Component)clickToSendComponent);
    }

    public static Component handleChatMessage(Component message) {
        if (ConfigProvider.getConfig().isEmojifulCompatibilityEnabled() && !EmojiParser.extractEmojis(message.getString()).isEmpty()) {
            MutableComponent withReplacedEmojis = Component.empty();
            for (Component comp : message.toFlatList()) {
                withReplacedEmojis.append((Component)Component.literal((String)EmojiParser.parseToAliases(comp.getString())).withStyle(comp.getStyle()));
            }
            return withReplacedEmojis;
        }
        return message;
    }

    public static void handleJoinServer() {
        DiscordMentionsTransceiver.requestDiscordMemberData();
        DiscordEmojisTransceiver.requestDiscordEmojis();
        DiscordStickersTransceiver.requestDiscordStickers();
    }
}

