/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod;

import com.denisnumb.discord_chat_mod.DiscordChatMod;
import com.denisnumb.discord_chat_mod.chat_style.ChatStyleUtils;
import com.denisnumb.discord_chat_mod.config.ConfigProvider;
import com.denisnumb.discord_chat_mod.discord.ChannelMembersProvider;
import com.denisnumb.discord_chat_mod.discord.DiscordUtils;
import com.denisnumb.discord_chat_mod.discord.model.ChannelCategory;
import com.denisnumb.discord_chat_mod.discord.model.DiscordMentionData;
import com.denisnumb.discord_chat_mod.discord.model.DiscordUserData;
import com.denisnumb.discord_chat_mod.markdown.MarkdownParser;
import com.denisnumb.discord_chat_mod.markdown.MarkdownToComponentConverter;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MinecraftUtils {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static ProcessChatMessageResult processChatMessage(String message, ChannelCategory chatCategoryToParseMembers) {
        HashMap<String, DiscordMentionData> mentions = Map.of();
        String forDiscord = message;
        if (DiscordChatMod.isDiscordConnected()) {
            final List<DiscordUserData> memberData = ChannelMembersProvider.getMemberData(chatCategoryToParseMembers);
            for (DiscordUserData member : memberData) {
                if (!message.contains(member.prettyMention)) continue;
                message = message.replace(member.prettyMention, member.mentionString);
            }
            mentions = new HashMap<String, DiscordMentionData>(){
                {
                    for (DiscordUserData member : memberData) {
                        this.put(member.mentionString, new DiscordMentionData(member));
                    }
                }
            };
            forDiscord = MarkdownParser.removeColorTags(DiscordUtils.replaceEmojiCodesToDiscordMentions(message));
        }
        MutableComponent forMinecraft = new MarkdownToComponentConverter(MarkdownParser.parseMarkdown(message), mentions).convertMarkdownTokensToComponent();
        return new ProcessChatMessageResult((Component)forMinecraft, forDiscord);
    }

    public static List<ServerPlayer> getPlayerListBySelector(String selector) {
        try {
            CommandSourceStack fakeSource = DiscordChatMod.server.createCommandSourceStack().withSuppressedOutput().withPermission(4);
            EntitySelectorParser parser = new EntitySelectorParser(new StringReader(selector), true);
            return parser.parse().findPlayers(fakeSource);
        }
        catch (Exception e) {
            return List.of();
        }
    }

    public static void sendMessageToPlayersBySelector(Component message, String selector) {
        try {
            for (ServerPlayer player : MinecraftUtils.getPlayerListBySelector(selector)) {
                player.sendSystemMessage((Component)ComponentUtils.updateForEntity(null, (Component)message, (Entity)player, (int)0), false);
            }
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendMessageToAllPlayers(Component message) {
        MinecraftUtils.sendMessageToPlayersBySelector(message, "@a");
    }

    public static void sendMessageToAllPlayersFromPlayer(Map<String, Component> parameters) {
        String template = ConfigProvider.getConfig().isMinecraftChatCustomizationEnabled() ? ConfigProvider.getConfig().minecraftPlayerMessageStyle() : "<{player}> {message}";
        MinecraftUtils.sendMessageToAllPlayers((Component)ChatStyleUtils.applyParametersToTemplate(ChatStyleUtils.parseConfigTemplateMarkdown(template), parameters));
    }

    public static void showTitleBarMessage(Component message) {
        Minecraft.getInstance().gui.setOverlayMessage(message, false);
    }

    public static void logErrorToServer(String message) {
        LOGGER.error(message);
        if (ConfigProvider.getConfig().isLoggingDiscordErrorsToServerChatEnabled()) {
            MinecraftUtils.sendMessageToPlayersBySelector(MinecraftUtils.buildLogMessageComponent(message, ChatFormatting.RED.getColor()), ConfigProvider.getConfig().discordErrorsChatPlayerSelector());
        }
    }

    public static void logWarnToServer(String message) {
        LOGGER.warn(message);
        if (ConfigProvider.getConfig().isLoggingDiscordErrorsToServerChatEnabled()) {
            MinecraftUtils.sendMessageToPlayersBySelector(MinecraftUtils.buildLogMessageComponent(message, ChatFormatting.YELLOW.getColor()), ConfigProvider.getConfig().discordErrorsChatPlayerSelector());
        }
    }

    public static int getServerPlayerCount(@Nullable MinecraftServer server) {
        if (server != null && server.getPlayerList() != null) {
            return server.getPlayerCount();
        }
        return 0;
    }

    public static int getServerMaxPlayers(@Nullable MinecraftServer server) {
        if (server != null && server.getPlayerList() != null) {
            return server.getMaxPlayers();
        }
        return 20;
    }

    public static String[] getServerPlayerNames(@Nullable MinecraftServer server) {
        if (server != null && server.getPlayerList() != null) {
            return server.getPlayerNames();
        }
        return new String[0];
    }

    private static Component buildLogMessageComponent(String message, int color) {
        return Component.empty().append((Component)Component.literal((String)"[discord_chat_mod] ").withStyle(style -> style.withBold(Boolean.valueOf(true)))).append((Component)Component.literal((String)message)).withColor(color);
    }

    public record ProcessChatMessageResult(Component forMinecraft, String forDiscord) {
    }
}

