/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.advancement;

import com.denisnumb.discord_chat_mod.DiscordChatMod;
import com.denisnumb.discord_chat_mod.LocaleProvider;
import com.denisnumb.discord_chat_mod.advancement.AdvancementDisplayComponent;
import com.denisnumb.discord_chat_mod.advancement.AdvancementDisplayComponentDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AdvancementParser {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(AdvancementDisplayComponent.class, (Object)new AdvancementDisplayComponentDeserializer()).create();

    @Nullable
    public static JsonObject getAdvancementFileAsJsonObject(ResourceLocation resourceLocation) {
        try {
            Optional resource = DiscordChatMod.server.getResourceManager().getResource(resourceLocation);
            InputStreamReader reader = new InputStreamReader(((Resource)resource.get()).open(), StandardCharsets.UTF_8);
            return (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        catch (Exception e) {
            LOGGER.error("AdvancementFileNotFound: {}", (Object)resourceLocation);
            e.printStackTrace();
            return null;
        }
    }

    public static String getTranslatedAdvancementTitle(JsonObject advancementJson, String defaultValue) {
        return AdvancementParser.getTranslatedAdvancementField("title", advancementJson, defaultValue);
    }

    public static String getTranslatedAdvancementDescription(JsonObject advancementJson, String defaultValue) {
        return AdvancementParser.getTranslatedAdvancementField("description", advancementJson, defaultValue);
    }

    private static String getTranslatedAdvancementField(String fieldKey, JsonObject advancementJson, String defaultValue) {
        AdvancementDisplayComponent component = AdvancementParser.parseAdvancementField(advancementJson, fieldKey);
        if (component == null) {
            return defaultValue;
        }
        String translatedValue = AdvancementParser.translateAndFormatRecursively(component);
        return translatedValue == null || translatedValue.split("%s", -1).length - 1 > 0 ? defaultValue : translatedValue;
    }

    @Nullable
    private static String translateAndFormatRecursively(AdvancementDisplayComponent component) {
        Object[] formattedArgs;
        String text;
        String string = text = component.text != null ? component.text : LocaleProvider.getTranslate(component.translate);
        if (text.equals(component.translate)) {
            return null;
        }
        text = component.applyStyles(text);
        if (component.with != null && !component.with.isEmpty() && (formattedArgs = component.with.stream().map(AdvancementParser::translateAndFormatRecursively).filter(Objects::nonNull).toArray()).length == text.split("%s", -1).length - 1) {
            return String.format(text, formattedArgs);
        }
        return text;
    }

    @Nullable
    private static AdvancementDisplayComponent parseAdvancementField(JsonObject advancementJson, String fieldKey) {
        JsonObject display;
        if (advancementJson.has("display") && (display = advancementJson.getAsJsonObject("display")).has(fieldKey)) {
            return (AdvancementDisplayComponent)GSON.fromJson(display.get(fieldKey), AdvancementDisplayComponent.class);
        }
        return null;
    }
}

