/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.chat_images;

import com.denisnumb.discord_chat_mod.chat_images.model.AbstractImage;
import com.denisnumb.discord_chat_mod.chat_images.model.AnimatedImage;
import com.denisnumb.discord_chat_mod.chat_images.model.Image;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ImageScreen
extends Screen {
    private final AbstractImage image;
    private final int imageWidth;
    private final int imageHeight;
    private int centerX = 0;
    private int centerY = 0;
    private int renderWidth = 0;
    private int renderHeight = 0;

    public ImageScreen(AbstractImage image) {
        super((Component)Component.literal((String)"Image Viewer"));
        this.image = image;
        this.imageWidth = image.originalSize.width();
        this.imageHeight = image.originalSize.height();
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ResourceLocation resourceLocation;
        super.render(graphics, mouseX, mouseY, partialTicks);
        RenderSystem.disableDepthTest();
        graphics.fill(0, 0, this.width, this.height, -2013265920);
        RenderSystem.enableDepthTest();
        int maxWidth = (int)((double)this.width * 0.7);
        int maxHeight = (int)((double)this.height * 0.7);
        double scale = Math.min(1.0, Math.min((double)maxWidth / (double)this.imageWidth, (double)maxHeight / (double)this.imageHeight));
        this.renderWidth = (int)((double)this.imageWidth * scale);
        this.renderHeight = (int)((double)this.imageHeight * scale);
        this.centerX = (this.width - this.renderWidth) / 2;
        this.centerY = (this.height - this.renderHeight) / 2;
        AbstractImage abstractImage = this.image;
        if (abstractImage instanceof AnimatedImage) {
            AnimatedImage gif = (AnimatedImage)abstractImage;
            resourceLocation = gif.getCurrentFrame();
        } else {
            resourceLocation = ((Image)this.image).resourceLocation;
        }
        ResourceLocation resourceLocation2 = resourceLocation;
        graphics.blit(resourceLocation2, this.centerX, this.centerY, 0.0f, 0.0f, this.renderWidth, this.renderHeight, this.renderWidth, this.renderHeight);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            boolean outsideImage;
            boolean bl = outsideImage = mouseX < (double)this.centerX || mouseX > (double)(this.centerX + this.renderWidth) || mouseY < (double)this.centerY || mouseY > (double)(this.centerY + this.renderHeight);
            if (outsideImage) {
                Minecraft.getInstance().setScreen(null);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            Minecraft.getInstance().setScreen(null);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

