/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.chat_images.model;

import com.denisnumb.discord_chat_mod.chat_images.model.AbstractImage;
import com.denisnumb.discord_chat_mod.chat_images.model.ImageSize;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class AnimatedImage
extends AbstractImage {
    public final List<ResourceLocation> frames;
    public final int frameDuration;

    public AnimatedImage(String url, List<ResourceLocation> frames, ImageSize imageSize, ImageSize originalSize, int frameDuration, boolean isSpoiler, ResourceLocation spoilerResourceLocation) {
        super(url, imageSize, originalSize, isSpoiler, spoilerResourceLocation);
        this.frames = frames;
        this.frameDuration = frameDuration;
    }

    public ResourceLocation getCurrentFrame() {
        long time = System.currentTimeMillis();
        int totalDuration = this.frames.size() * this.frameDuration;
        long timeInLoop = time % (long)totalDuration;
        int elapsedTime = 0;
        for (ResourceLocation frame : this.frames) {
            if ((long)(elapsedTime += this.frameDuration) <= timeInLoop) continue;
            return frame;
        }
        return this.frames.getFirst();
    }
}

