/*
 * Decompiled with CFR 0.152.
 */
package com.denisnumb.discord_chat_mod.chat_style;

import com.denisnumb.discord_chat_mod.LocaleProvider;
import com.denisnumb.discord_chat_mod.config.ConfigProvider;
import com.denisnumb.discord_chat_mod.config.IConfigProvider;
import com.denisnumb.discord_chat_mod.markdown.MarkdownParser;
import com.denisnumb.discord_chat_mod.markdown.MarkdownToComponentConverter;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import org.jetbrains.annotations.Nullable;

public class ChatStyleUtils {
    public static Map<String, Style> parseTemplateParameterStyles(MutableComponent template, String ... parameters) {
        HashMap<String, Style> parameterStyles = new HashMap<String, Style>();
        String orPattern = Arrays.stream(parameters).map(Pattern::quote).collect(Collectors.joining("|"));
        Pattern parameterPattern = Pattern.compile(orPattern);
        for (Component templatePart : template.toFlatList()) {
            String templateString = templatePart.getString();
            Matcher matcher = parameterPattern.matcher(templateString);
            if (!matcher.find()) continue;
            do {
                parameterStyles.put(matcher.group(), templatePart.getStyle());
            } while (matcher.find());
        }
        return parameterStyles;
    }

    @Nullable
    public static String getConfigTemplateByChatType(ResourceKey<ChatType> key) {
        IConfigProvider config = ConfigProvider.getConfig();
        return switch (key.location().getPath()) {
            case "chat" -> config.minecraftPlayerMessageStyle();
            case "say_command" -> config.minecraftSayCommandStyle();
            case "msg_command_incoming" -> ChatStyleUtils.setConfigTemplateTranslatableParameters(config.minecraftTellMessageReceivedStyle(), "commands.message.display.incoming");
            case "msg_command_outgoing" -> ChatStyleUtils.setConfigTemplateTranslatableParameters(config.minecraftTellMessageSentStyle(), "commands.message.display.outgoing");
            case "team_msg_command_incoming" -> config.minecraftTeamMessageReceivedStyle();
            case "team_msg_command_outgoing" -> config.minecraftTeamMessageSentStyle();
            case "emote_command" -> config.minecraftMeCommandStyle();
            default -> null;
        };
    }

    public static MutableComponent parseConfigTemplateMarkdown(String configTemplate) {
        return new MarkdownToComponentConverter(MarkdownParser.parseMarkdown(configTemplate)).convertMarkdownTokensToComponent();
    }

    public static String setConfigTemplateTranslatableParameters(String configTemplate, String ... translatableParameters) {
        String result = configTemplate;
        for (String param : translatableParameters) {
            result = result.replace(String.format("{%s}", param), ChatStyleUtils.clearTranslatedString(LocaleProvider.getTranslate(param)));
        }
        return result;
    }

    public static MutableComponent applyParametersToTemplate(MutableComponent template, Map<String, Component> parameterToComponent) {
        parameterToComponent = ChatStyleUtils.mergeMaps(parameterToComponent, ChatStyleUtils.buildTimestampParameters());
        MutableComponent result = Component.empty();
        String orPattern = parameterToComponent.keySet().stream().map(Pattern::quote).collect(Collectors.joining("|"));
        Pattern parameterPattern = Pattern.compile(orPattern);
        for (Component templatePart : template.toFlatList()) {
            String templateString = templatePart.getString();
            Matcher matcher = parameterPattern.matcher(templateString);
            if (!matcher.find()) {
                result.append((Component)Component.literal((String)templateString).withStyle(templatePart.getStyle()));
                continue;
            }
            int currentPos = 0;
            do {
                String textBefore = templateString.substring(currentPos, matcher.start());
                result.append((Component)Component.literal((String)textBefore).withStyle(templatePart.getStyle()));
                Component toReplace = (Component)parameterToComponent.get(matcher.group());
                if (toReplace != null) {
                    for (Component toReplaceInnerComp : toReplace.toFlatList()) {
                        result.append((Component)Component.literal((String)toReplaceInnerComp.getString()).withStyle(ChatStyleUtils.mergeStyles(toReplaceInnerComp.getStyle(), templatePart.getStyle())));
                    }
                }
                currentPos = matcher.end();
            } while (matcher.find());
            if (currentPos >= templateString.length()) continue;
            String textAfter = templateString.substring(currentPos);
            result.append((Component)Component.literal((String)textAfter).withStyle(templatePart.getStyle()));
        }
        return result;
    }

    public static Map<String, Component> buildTimestampParameters() {
        HashMap<String, Component> result = new HashMap<String, Component>();
        OffsetDateTime now = ChatStyleUtils.getDateTimeWithUtcOffset();
        result.put("{HH}", (Component)Component.literal((String)String.format("%02d", now.getHour())));
        result.put("{MM}", (Component)Component.literal((String)String.format("%02d", now.getMinute())));
        result.put("{SS}", (Component)Component.literal((String)String.format("%02d", now.getSecond())));
        return result;
    }

    public static OffsetDateTime getDateTimeWithUtcOffset() {
        Instant nowUtc = Instant.now();
        ZoneOffset offset = ZoneOffset.ofHours(ConfigProvider.getConfig().utcOffsetHours());
        return nowUtc.atOffset(offset);
    }

    @SafeVarargs
    public static <T> Map<String, T> mergeMaps(Map<String, T> ... parameterMaps) {
        return Arrays.stream(parameterMaps).flatMap(m -> m.entrySet().stream()).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static <T> T nullSafeElse(T first, T second) {
        return first != null ? first : second;
    }

    private static Style mergeStyles(Style main, Style second) {
        return Style.EMPTY.withBold(Boolean.valueOf(main.isBold() || second.isBold())).withItalic(Boolean.valueOf(main.isItalic() || second.isItalic())).withUnderlined(Boolean.valueOf(main.isUnderlined() || second.isUnderlined())).withStrikethrough(Boolean.valueOf(main.isStrikethrough() || second.isStrikethrough())).withObfuscated(Boolean.valueOf(main.isObfuscated() || second.isObfuscated())).withColor(ChatStyleUtils.nullSafeElse(main.getColor(), second.getColor())).withClickEvent(ChatStyleUtils.nullSafeElse(main.getClickEvent(), second.getClickEvent())).withHoverEvent(ChatStyleUtils.nullSafeElse(main.getHoverEvent(), second.getHoverEvent())).withInsertion(ChatStyleUtils.nullSafeElse(main.getInsertion(), second.getInsertion()));
    }

    private static String clearTranslatedString(String text) {
        return text.replaceAll("%s|:|\u00ab|\u00bb", "").trim();
    }
}

